package fractal;

public final class Complex implements IComplex {
    private double realPart;
    private double imagPart;

    public Complex(double real, double imag) {
        realPart = real;
        imagPart = imag;
    }
    
    public IComplex add(IComplex other) {
        return new Complex(
            realPart+other.realPart(),
            imagPart+other.imagPart());
    }
    
    public IComplex subtract(IComplex other) {
        return new Complex(
            realPart-other.realPart(),
            imagPart-other.imagPart());
    }

    public IComplex multiply(IComplex other) {
        return new Complex(
            realPart*other.realPart() - imagPart*other.imagPart(),
            realPart*other.imagPart() + imagPart*other.realPart());
            
    }
    
    public IComplex square() {
        return new Complex(
            realPart*realPart-imagPart*imagPart,
            2*realPart*imagPart);
    }
    
    public IComplex conjugate() {
        return new Complex(realPart, -imagPart);
    }
    
    public double value() {
        return Math.sqrt(value2());
    }

    public double value2() {
        return realPart*realPart + imagPart*imagPart;
    }
    
    public double realPart() {
        return realPart;
    }
    
    public double imagPart() {
        return imagPart;
    }
}
