package fractal;

public class Sequence {
    private int maxCount;
    
    public Sequence(int maxCount) {
        this.maxCount = maxCount;
    }
    
    public int next(IComplex c) {
        int count = 0;
        IComplex z = new Complex(0, 0);
        while (count < maxCount && z.value2() < 4.) { 
            z = z.multiply(z).add(c);
            count++;
        }
        return count;
    }
    
    public int nextf(double x, double y) {
        int count = 0;
        double zx = 0.;
        double zy = 0.;
        while (count < maxCount && zx*zx+zy*zy < 4) { 
            double t  = zx * zx - zy * zy + x;
            zy = 2 * zx * zy + y;
            zx = t;
            count++;
        }
        return count;
    }
    
    public int next(double x, double y) {
        return nextf(x, y);
        //return next(new Complex(x, y));
    }
}
