package jgen;
import java.util.*;

interface Function<A,R> {
    R apply(A x);
}

class Functions {
    static <T> List<T> forAll(
        List<? extends T> lst, Function<? super T, T> f)
    {
        List<T> r = new ArrayList<T>();
        for (T x : lst) r.add(f.apply(x));
        return r;
    }
    
    public static void main(String[] args) {
        List<Integer> lst = Arrays.asList(1, 2, 3);
        Function<Object, Integer>  f = new Function<Object, Integer>() {
            public Integer apply(Object x) {
                return (x instanceof Integer)
                    ? 2 * (Integer) x
                    : 0;
            }
        };
        List<?> result = forAll(lst, f);
        System.out.println(result);
    }
}
