package jgen;
import java.util.Comparator;

public final class MaxStore<T> {
    private class Entry {
        T value;
        Entry(T value) { this.value = value; }
    }
    private Entry first = null;
    private Comparator<? super T> cmp;

    public MaxStore(Comparator<? super T> cmp) { this.cmp = cmp; }
    public T get() { return first.value; }
    public boolean isEmpty() { return first == null; }
    public void put(T obj) {
        if (isEmpty())
            first = new Entry(obj);
        else if (cmp.compare(obj, first.value) > 0)
            first.value = obj;
    }
    public void clear() { first = null; }
    
    public static void main(String[] args) {
        MaxStore<String> q = new MaxStore<String>(
                new Comparator<Object>() {
                    public int compare(Object a, Object b) {
                        return 1;
                    }
                });
        q.put("x");
    }
}
