package sgen

trait Comparator[-T] {
    def compare(a: T, b: T): Int
}

class MaxStore[T](val cmp: Comparator[T]) {
    private class Entry[T](var value: T)
    private var first: Entry[T] = null
    
    def get = first.value
    def isEmpty = first == null
    def put(obj: T) {
        if (isEmpty)
            first = new Entry[T](obj)
        else if (cmp.compare(obj, first.value) > 0)
            first.value = obj
    }
    def clear(): Unit = first = null 
}

object MaxStore {
    def main(args: Array[String]) {
        val q = new MaxStore[String](new Comparator[Any] {
            def compare(a: Any, b: Any) = 1
        })
        q.put("x")
    }  
}