package util

object Account {
  type Method = Double => Double
  
  def makeAccount(initialBalance: Double): Symbol=>Method = {
    var balance = initialBalance

    def withdraw(amount: Double): Double = {
      require(amount < balance)
      balance -= amount
      balance
    }

    def deposit(amount: Double): Double = {
      balance += amount
      balance
    }

    def dispatch(s: Symbol): Method = s match {
        case 'withdraw => withdraw 
        case 'deposit  => deposit _
    }

    dispatch _
  }

  def main(args: Array[String]) {
    val account1 = makeAccount(100)
    val account2 = makeAccount(1000)
    
    println("acc1: " + account1('deposit)(100))
    println("acc2: " + account2('deposit)(1000))
    println("acc1: " + account1('withdraw)(50))
    println("acc2: " + account2('withdraw)(500))
  }
}