package util

import scala.collection.mutable.ListBuffer

/**
 * Beispiel fuer selbstgeschriebene Kontrollabstraktionen.
 * In dem Beispiel werden positive Zahlen eingelesen und ihre Summe wird ermittelt.
 */
object Control {
  def main(args: Array[String]): Unit = {
    println("Bitte positive Gleitkommazahlen eingeben (Ende < 0)")
    //                                Ein Listbuffer erlaubt das dynamische
    //                                Aufbauen einer Liste
    val b = new ListBuffer[Double]
    var ok = true
    while(ok) {
      val input = repeat("naechste Zahl", "Eingabefehler") (readDouble)
      ok = input >= 0.0
      if (ok) b += input
    }
    val array = b.toArray
    var s = 0.0
    printf("Die Arrayelemente lauten:")
    //                                Das entspricht dem C-for: 
    //                                for(int i = 0; i < array.length; i++)
    doFor(0, array.length - 1) { i =>
      printf("%4.1f ", array(i))
      s += array(i)
    }
    printf("%nDie Summe ist:   %4.2f%n", s)
    //                                mit Monoids ist das einfacher
    printf("Probe mit fold:  %4.2f%n", array.foldLeft(0.0)(_+_))
    printf("Probe mit sum:   %4.2f%n", array.sum)
  }

  /**
   * Die For-Schleife. Diese Schleife funktioniert nur aufsteigend.
   * Uebungsaufgabe: verbessern Sie diese Definition, so dass beliebige
   * Zaehlschleifen moeglich sind.
   * @param T der Typparameter erlaubt beliebige Ausdruecke
   * @param from Startwert
   * @param to EndeWert
   * @param step Schrittweite
   * @param body Schleifenkoerper
   */
  def doFor[T](from: Int, to: Int, step: Int = 1)(body: Int => T): Unit = {
    var loopVar = from
    while (loopVar <= to) {
      body(loopVar)
      loopVar += step
    }
  }
  
  /**
   * Dies ist das Vorlesungsbeispiel, des eingekapselten Exception-
   * Auffangens
   */
  def repeat[T](prompt: String, errorMessage: String)(request: => T): T = {
    try {
      print(prompt + ": ")
      request
    }
    catch {
      case _: Exception =>
        println(errorMessage)
        repeat(prompt, errorMessage)(request)
    }
  }
}