package monads

import Thread.sleep
import System.nanoTime
import scala.concurrent._
import ExecutionContext.Implicits.global
import duration.Duration

/**
 * Futures als Monaden.
 * Die Reihenfolge der Ausgabe ist nicht genau festgelegt.
 */
object FutureExample {
  def main(args: Array[String]) {
    val t1 = nanoTime()

    val f1 = future {
      sleep(5000)
      val result = 42
      println("Result1: " + result)
      result
    }

    val f2 = future {
      sleep(4000)
      val result = 17
      println("Result2: " + result)
      result
    }

    val s = for {
      x1 <- f1
      x2 <- f2
    } yield x1 + x2

    println("all futures started")

    for (ergebnis <- s)
      println("final result: " + ergebnis)

    s onSuccess {
      case x => println("one more time: " + x)
    }

    println("and waiting for results")
    Await.result(s, Duration(10000, "millis"))
    println(f1)

    val t2 = nanoTime()
    println("total time: " + "%.1f".format(1e-9 * (t2 - t1)) + " s")
  }
}