package monads

/*
 * Das Beispiel zeigt den Zusammenhang von monadischen Funktionen und der
 * for comprehension. Es ist sinnvoll sich in eclipse anzuschauen, wie das
 * <- uebersetzt wird und welche Typen die Variablen haben.
 */
object MonadApplications {
  def main(args: Array[String]) {
    // finde 3 unterschiedliche 1-stellige Zahlen, deren Summe = 20 ist
    withFor
    withMonads
    withExpressions
  }

  // Diese einfache Schreibweise mit for erfuellt den Zweck.
  // Es werden nur aufsteigende Zahlentripel ermittelt.
  def withFor: Unit = {
    val numbers = (1 to 9).toSet
    val result = for {
      n1 <- numbers
      n2 <- numbers if n2 > n1
      n3 <- numbers if n3 > n2
      if (n1 + n2 + n3 == 20)
    } yield (n1, n2, n3)
    println(result)
  }
  
  // Diese Form ist exakt gleich dem Ablauf von withFor.
  def withMonads: Unit = {
    val numbers = (1 to 9).toSet
    val result =
      numbers.flatMap(n1 =>
         numbers.filter(_>n1).flatMap(n2 => 
            numbers.filter(n3 =>n3 > n2 && n1+n2+n3 == 20).map(n3 => 
              (n1,n2,n3))))
     println(result)
  }

  // Diese Form vermeidet das Ausprobieren bereits verwendeter Zahlen.
  // Mit for ist das ziemlich einfach. Direkt mit monadischen Funktionen
  // aber schon ziemlich kompliziert.
  def withExpressions: Unit = {
    val numbers = (1 to 9).toSet
    val result = for {
      n1 <- numbers
      rest1 = numbers - n1
      n2 <- rest1 if n2 > n1
      rest2 = numbers - n2
      n3 <- rest2 if n3 > n2
      if (n1 + n2 + n3 == 20)
    } yield (n1, n2, n3)
    println(result)
  }
}