package jv;

public class ComputePi {
    public static void main(String[] args) {
        double[] seq = new double[20];
        double s = 4.0;
        for (int i = 0; i < seq.length; i++) {
            seq[i] = s / (2 * i + 1);
            s = -s;
        }
        double[] piSeries = partialSums(seq);
        double[] shanksTransform1 = shanksTransform(piSeries);
        double[] shanksTransform2 = shanksTransform(shanksTransform1);
        //  ...
        int print2N = 10;
        Transform shanks = new Transform() {
            public double[] apply(double[] a) {
                return shanksTransform(a);
            }
        };
        double[] shanksTransformOpt = accSeq(piSeries, shanks, print2N);
        printStream("PI-Series", piSeries, print2N);
        printStream("Shanks-1", shanksTransform1, print2N);
        printStream("Shanks-2", shanksTransform2, print2N);
        printStream("optimal", shanksTransformOpt, print2N);
        System.out.printf("%nmath.Pi%n%.15f%n", Math.PI);
    }

    /**
     * Berechnet die Partialsummen einer Zahlenfolge
     * 
     * @param s
     *        Zahlenfolge
     * @return Partialsummen
     */
    static double[] partialSums(double[] a) {
        double[] b = new double[a.length];
        double s = 0.0;
        for (int i = 0; i < a.length; i++) {
            s += a[i];
            b[i] = s;
        }
        return b;
    }

    /**
     * Berechnet die Shank's Transformierte einer Zahlenfolge
     * 
     * @param s
     *        Zahlenfolge
     * @return Transformierte
     */
    static double[] shanksTransform(double[] a) {
        double[] b = new double[a.length - 2];
        for (int i = 0; i < b.length; i++) {
            double ad = a[i + 2] - a[i + 1];
            b[i] = a[i + 2] - (ad * ad) / (a[i] - 2 * a[i + 1] + a[i + 2]);
        }
        return b;
    }

    /**
     * Bildet die forgesetzte Transformation einer Zahlenfolge, gibt
     * aber jeweils nur das Anfangselement jeder Folge zurueck.
     * Wenn s die Eingangsfolge ist, so ist das Ergebnis die Folge s(0),
     * tf(s)(0), tf(tf(s))(0) usw.
     * 
     * @param s
     *        Zahlenfolge
     * @param tf
     *        Transformationsfunktion
     * @return Folge der ersten Folgenelemente der Transformationen
     */
    static double[] accSeq(double[] a, Transform t, int n) {
        double[][] c = makeTableau(a, t, n);
        double[] b = new double[n];
        for (int i = 0; i < b.length; i++)
            b[i] = c[i][0];
        return b;
    }
    
    /**
     * Bildet fortgesetzte Transformationen einer Zahlenfolge.
     * Wenn s die Eingabefolge ist, so ist das Ergebnis die Folge s,
     * tf(s), tf(tf(s)) usw.
     * @param s Zahlenfolge
     * @param tf Transformationsfunktion
     * @return Folg der transformierten Folgen.
     */
    static double[][] makeTableau(double[] a, Transform tf, int n) {
        double[][] b = new double[n][];
        b[0] = a;
        for (int i = 1; i < b.length; i++)
            b[i] = tf.apply(b[i-1]);
        return b;
    }

    /**
     * Ausgabe von n Elementen eines Streams.
     * 
     * @param title
     *        Titel der Ausgabe
     * @param s
     *        der auszugebende Stream
     * @param n
     *        die Anzahl der Elemente
     */
    static void printStream(String title, double[] a, int n) {
        System.out.println("\n" + title);
        for (int i = 0; i < n; i++)
            System.out.printf("%.15f%n", a[i]);
    }
}
