import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import org.eclipse.swt.widgets.Text;

public class BlowfishGui {

	public BlowfishGui() {
		super();
		// TODO Auto-generated constructor stub
	}

	public void init(final Shell shell) {
		RowLayout row = new RowLayout();
		// grid.
		shell.setLayout(row);
		Label keyLabel = new Label(shell, SWT.NULL);
		keyLabel.setText("Schluessel:");
		RowData keyLabelData = new RowData();
		keyLabelData.width = 80;
		keyLabel.setLayoutData(keyLabelData);
		final Text keyText = new Text(shell, SWT.MULTI
												| SWT.BORDER
												| SWT.H_SCROLL
												| SWT.V_SCROLL);
		RowData keyTextData = new RowData();
		keyTextData.width = 290;
		keyTextData.height = 100;
		keyText.setLayoutData(keyTextData);
		Label normalTextLabel = new Label(shell, SWT.NULL);
		normalTextLabel.setText("Text: ");
		RowData normalTextLabelData = new RowData();
		normalTextLabelData.width = 80;
		normalTextLabel.setLayoutData(normalTextLabelData);
		final Text normalText = new Text(shell, SWT.MULTI
												| SWT.BORDER
												| SWT.H_SCROLL
												| SWT.V_SCROLL);
		RowData normalTextData = new RowData();
		normalTextData.width = 290;
		normalTextData.height = 100;
		normalText.setLayoutData(normalTextData);
		Label encdecodetLabel = new Label(shell, SWT.NULL);
		encdecodetLabel.setText("En-/Decodet Text:");
		RowData encdecodetLabelData = new RowData();
		encdecodetLabelData.width = 100;
		encdecodetLabel.setLayoutData(encdecodetLabelData);
		final Text encdecodetText = new Text(shell, SWT.MULTI
													| SWT.BORDER
													| SWT.H_SCROLL
													| SWT.V_SCROLL);
		RowData encdecodetTextData = new RowData();
		encdecodetTextData.width = 290;
		encdecodetTextData.height = 100;
		encdecodetText.setLayoutData(encdecodetTextData);
		Button encodeButton = new Button(shell, SWT.PUSH);
		encodeButton.setText("Encode");
		encodeButton.addSelectionListener(new SelectionListener() {

			public void widgetSelected(SelectionEvent e) {
				
				
				if (keyText.getText() != null
					&& keyText.getText().length() != 0 && normalText.getText() != null
					&& normalText.getText().length() != 0) {
					
//					ExperimintelleAnalyse exp=new ExperimintelleAnalyse();
//					for(int i=0;i<=12800;i+=1024){
						Blowfish blow = new Blowfish(keyText.getText());
//						String tmpString=exp.randomstring(i);
//						blow.encodeString(tmpString);
//						System.out.println(tmpString.length()+";"+(blow.getExpAnalyse().getOperationen()/(16744+16*tmpString.length())));
//					System.out.println((Math.log(blow.getExpAnalyse().getOperationen())/Math.log(2))+";"+(Math.log(tmpString.length())/Math.log(2)));	
						
//					}
					
					encdecodetText.setText(blow.encodeString(normalText.getText().trim()));
					
					
				}
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		RowData encodeButtonData = new RowData();
		encodeButtonData.width = 100;
		encodeButton.setLayoutData(encodeButtonData);
		Button decodeButton = new Button(shell, SWT.PUSH);
		decodeButton.setText("Decode");
		decodeButton.addSelectionListener(new SelectionListener() {

			public void widgetSelected(SelectionEvent e) {
				if (keyText.getText() != null
						&& keyText.getText().length() != 0 && normalText.getText() != null
						&& normalText.getText().length() != 0) {
					Blowfish blow = new Blowfish(keyText.getText());
					encdecodetText.setText(blow.decodeString(normalText.getText()));
				}
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		RowData decodeButtonData = new RowData();
		decodeButtonData.width = 100;
		decodeButton.setLayoutData(decodeButtonData);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Display display = new Display();
		final Shell shell = new Shell(display, SWT.CLOSE);
		shell.setSize(330, 500);
		shell.setText("Blowfish");
		BlowfishGui dialog = new BlowfishGui();
		dialog.init(shell);
		shell.open();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		display.dispose();
	}
}
