<?xml version="1.0"?>

<xsl:stylesheet version="1.0">

  <xsl:template match="/">
   <html>
    <head>
     <title>
        <xsl:value-of select="//header/title"/>
     </title>
     <h2><xsl:value-of select="//header/title"/></h2>
    </head>
    <body bgcolor="white" alink="red" link="blue" vlink="blue">
    
        <table border="1">
            <tr>
                <th>Zugtyp</th>
                <th>ZugNr</th>
                <th>von</th>
                <th>ab</th>
                <th>Gleis</th>
                <th>nach</th>                
                <th>an</th>
                <th>Gleis</th>
                <th>Zyklus</th>                
                <th>Restaurant</th>
                <th>Internet</th>
                <th>Schlafwg</th>
                <th>PKW</th>
                <th>Fahrrad</th>
            </tr>
            <xsl:apply-templates/>
       </table>
    </body>
   </html>
  </xsl:template>
  
  <xsl:template match="title">
  </xsl:template>  
  

  <xsl:template match="zug">
    <xsl:apply-templates/>
  </xsl:template>  
  
  <xsl:template match="verbindung">
    <tr><xsl:apply-templates/></tr>
  </xsl:template>
  
  <xsl:template match="zyklus">
    <td><xsl:value-of select="."/></td>
  </xsl:template>
  
  <xsl:template match="zugtyp">
    <td><xsl:value-of select="."/></td>
  </xsl:template>  
  
  <xsl:template match="zugnummer">
    <td style="color:'red'"><xsl:value-of select="."/></td>
  </xsl:template>

  <xsl:template match="sitzplaetze"/>  


  <xsl:template match="bahnhof | zeit | bahnsteig">
    <td><xsl:value-of select="."/></td>
  </xsl:template>
  
  <xsl:template match="abfahrt">
    <xsl:apply-templates/>
  </xsl:template>  
  
  <xsl:template match="ankunft">
	<td><xsl:value-of select="bahnhof"/></td>
        <td style="color:'green'"><xsl:value-of select="zeit"/></td>
        <td><xsl:value-of select="bahnsteig" /></td>
  </xsl:template>
  
  <xsl:template match="ausstattung">
	<td><xsl:value-of select="restaurant" /></td>
        <td><xsl:value-of select="internet" /></td>
        <td><xsl:value-of select="schlafwagen" /></td>
        <td><xsl:value-of select="pkwmitnahme" /></td>
        <td><xsl:value-of select="fahrradmitnahme" /></td>
  </xsl:template>
  
  <xsl:template match="link">
  	<a>
  	<xsl:attribute name="href">
	<xsl:value-of select="@href"/>
	</xsl:attribute>
	<xsl:value-of select="."/>
	</a>
	<br/>
  </xsl:template>
  
</xsl:stylesheet>
