package klocke.ws0203.mci1.depot.xmlservlets;

/* Servlet: ShowServlet
 * written by: Heiner Klocke
 * Date: 21.11.2002
 * Modified on: 21. November 2002
 */

// JAXP packages
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.w3c.dom.*;

// Die Servletklassen 
import java.net.URL;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*; 
import java.sql.*;
import java.util.*;

// Die HTML User Interface Klassen
import klocke.ws0203.mci1.depot.xmluserinterface.*;
import klocke.ws0203.mci1.depot.database.DBVerbindung;

public class ShowServlet extends HttpServlet
{ 
  private static Connection verbindung = null;
  private StringBuffer buf = new StringBuffer();

  private static Emittenten emittenten;
  private static Aktien aktien;
  private static Waehrungen waehrungen;

  private static DocumentBuilderFactory dbf;
  private static DocumentBuilder dbl;

  public void init(ServletConfig config) throws ServletException
  {
    super.init(config);

    try{
        if (verbindung == null) {
            verbindung = DBVerbindung.login( "ShowServlet" );
            emittenten = new Emittenten(verbindung);
            aktien = new Aktien(verbindung);
            waehrungen = new Waehrungen(verbindung);

        }
            
    }
    catch(SQLException exc){
        verbindung = null;
        System.err.println(exc.toString());
    }
    
    dbl = createDocumentBuilder();
  }

  protected void processRequest (HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException
  {
      
    String tabelle =  String.valueOf(request.getParameter("tabelle")).toString();
    System.out.println(tabelle);
    
    buf.setLength(0);
    response.setContentType("text/html");
    PrintWriter responseOutput = response.getWriter();
   
    
    if ( tabelle.equals("emittenten") )
        emittenten.selectRows(request, responseOutput, dbl);
    
    if ( tabelle.equals("aktien") )
        aktien.selectRows(request, responseOutput, dbl);

    if ( tabelle.equals("waehrungen") )
        waehrungen.selectRows(request, responseOutput, dbl);
    
    responseOutput.println(buf.toString());
    responseOutput.close();
    
  }  
   
  
  public void doGet (HttpServletRequest request, HttpServletResponse response) 
                    throws ServletException, IOException
  {
    processRequest( request, response );
  }
  
   public void doPost (HttpServletRequest request, HttpServletResponse response) 
                    throws ServletException, IOException
  {
    processRequest( request, response );
  } 

  public void destroy()
  { 
        if (verbindung != null) {
            DBVerbindung.logout("ShowServlet");
            verbindung = null;
        }
  }

  private DocumentBuilder createDocumentBuilder() {
      boolean dtdValidate = false;
      boolean xsdValidate = false;

      boolean ignoreWhitespace = false;
      boolean ignoreComments = false;
      boolean putCDATAIntoText = false;
      boolean createEntityRefs = false;

      dbf = DocumentBuilderFactory.newInstance();
      // Set namespaceAware to true to get a DOM Level 2 tree with nodes
      // containing namesapce information.  This is necessary because the
      // default value from JAXP 1.0 was defined to be false.
      dbf.setNamespaceAware(false);

      // Set the validation mode to either: no validation, DTD
      // validation, or XSD validation
      dbf.setValidating(dtdValidate || xsdValidate);

      // Optional: set various configuration options
      dbf.setIgnoringComments(ignoreComments);
      dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
      dbf.setCoalescing(putCDATAIntoText);
      // The opposite of creating entity ref nodes is expanding them inline
      dbf.setExpandEntityReferences(!createEntityRefs);
      
      try {
          dbl = dbf.newDocumentBuilder();
//          OutputStreamWriter errorWriter = new OutputStreamWriter(System.err, outputEncoding);
//          db.setErrorHandler(new MyErrorHandler(new PrintWriter(errorWriter, true)));
      } catch (Exception e) {
          e.printStackTrace();
      }          
      return dbl;
  }
  
}
