/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.Collection;
import weiss.util.Iterator;

public abstract class AbstractCollection
implements Collection {
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n++] = iterator.next();
        }
        return objectArray;
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!object.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!object.equals(iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)object;
        if (this.size() != collection.size()) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            if (this.isEqual(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    private boolean isEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public abstract Iterator iterator();

    public abstract boolean add(Object var1);

    public abstract int size();
}

