/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.ConcurrentModificationException;
import weiss.util.Iterator;
import weiss.util.List;
import weiss.util.ListIterator;
import weiss.util.NoSuchElementException;

public class ArrayList
extends AbstractCollection
implements List {
    private static final int DEFAULT_CAPACITY = 10;
    private static final int NOT_FOUND = -1;
    private Object[] theItems;
    private int theSize;
    private int modCount = 0;

    public ArrayList() {
        this.clear();
    }

    public ArrayList(Collection collection) {
        this.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public int size() {
        return this.theSize;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + n + "; size " + this.size());
        }
        return this.theItems[n];
    }

    public Object set(int n, Object object) {
        if (n < 0 || n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + n + "; size " + this.size());
        }
        Object object2 = this.theItems[n];
        this.theItems[n] = object;
        return object2;
    }

    public boolean contains(Object object) {
        return this.findPos(object) != -1;
    }

    private int findPos(Object object) {
        int n = 0;
        while (n < this.size()) {
            if (object == null ? this.theItems[n] == null : object.equals(this.theItems[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean add(Object object) {
        if (this.theItems.length == this.size()) {
            Object[] objectArray = this.theItems;
            this.theItems = new Object[this.theItems.length * 2 + 1];
            int n = 0;
            while (n < this.size()) {
                this.theItems[n] = objectArray[n];
                ++n;
            }
        }
        this.theItems[this.theSize++] = object;
        ++this.modCount;
        return true;
    }

    public boolean remove(Object object) {
        int n = this.findPos(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public Object remove(int n) {
        Object object = this.theItems[n];
        int n2 = n;
        while (n2 < this.size() - 1) {
            this.theItems[n2] = this.theItems[n2 + 1];
            ++n2;
        }
        --this.theSize;
        ++this.modCount;
        return object;
    }

    public void clear() {
        this.theSize = 0;
        this.theItems = new Object[10];
        ++this.modCount;
    }

    public Iterator iterator() {
        return new ArrayListIterator(0);
    }

    public ListIterator listIterator(int n) {
        return new ArrayListIterator(n);
    }

    private class ArrayListIterator
    implements ListIterator {
        private int current;
        private int expectedModCount;
        private boolean nextCompleted;
        private boolean prevCompleted;

        ArrayListIterator(int n) {
            this.expectedModCount = ArrayList.this.modCount;
            this.nextCompleted = false;
            this.prevCompleted = false;
            if (n < 0 || n > ArrayList.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.current = n;
        }

        public boolean hasNext() {
            if (this.expectedModCount != ArrayList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current < ArrayList.this.size();
        }

        public boolean hasPrevious() {
            if (this.expectedModCount != ArrayList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextCompleted = true;
            this.prevCompleted = false;
            return ArrayList.this.theItems[this.current++];
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.prevCompleted = true;
            this.nextCompleted = false;
            return ArrayList.this.theItems[--this.current];
        }

        public void remove() {
            if (this.expectedModCount != ArrayList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextCompleted) {
                ArrayList.this.remove(--this.current);
            } else if (this.prevCompleted) {
                ArrayList.this.remove(this.current);
            } else {
                throw new IllegalStateException();
            }
            this.nextCompleted = false;
            this.prevCompleted = false;
            ++this.expectedModCount;
        }
    }
}

