/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.Collection;
import weiss.util.Comparator;
import weiss.util.Iterator;
import weiss.util.NoSuchElementException;

public class Collections {
    static final Comparator DEFAULT_COMPARATOR = new DefaultComparator();

    private Collections() {
    }

    public static Object max(Collection collection) {
        return Collections.max(collection, DEFAULT_COMPARATOR);
    }

    public static Object max(Collection collection, Comparator comparator) {
        if (collection.size() == 0) {
            throw new NoSuchElementException();
        }
        Iterator iterator = collection.iterator();
        Object object = iterator.next();
        while (iterator.hasNext()) {
            Object object2 = iterator.next();
            if (comparator.compare(object2, object) <= 0) continue;
            object = object2;
        }
        return object;
    }

    public static Comparator reverseOrder() {
        return new ReverseComparator();
    }

    static class DefaultComparator
    implements Comparator {
        DefaultComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    }

    private static class ReverseComparator
    implements Comparator {
        private ReverseComparator() {
        }

        public int compare(Object object, Object object2) {
            return -((Comparable)object).compareTo(object2);
        }
    }
}

