/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import java.io.Serializable;
import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.ConcurrentModificationException;
import weiss.util.Iterator;
import weiss.util.NoSuchElementException;
import weiss.util.Set;

public class HashSet
extends AbstractCollection
implements Set {
    private static final int DEFAULT_TABLE_SIZE = 101;
    private int currentSize = 0;
    private int occupied = 0;
    private int modCount = 0;
    private HashEntry[] array;

    public HashSet() {
        this.allocateArray(101);
        this.clear();
    }

    public HashSet(Collection collection) {
        this.allocateArray(collection.size() * 2);
        this.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public int size() {
        return this.currentSize;
    }

    public Object getMatch(Object object) {
        int n = this.findPos(object);
        if (this.array[n] == null) {
            return null;
        }
        return this.array[n].element;
    }

    public boolean contains(Object object) {
        return HashSet.isActive(this.array, this.findPos(object));
    }

    private static boolean isActive(HashEntry[] hashEntryArray, int n) {
        return hashEntryArray[n] != null && hashEntryArray[n].isActive;
    }

    public boolean add(Object object) {
        int n = this.findPos(object);
        if (HashSet.isActive(this.array, n)) {
            return false;
        }
        this.array[n] = new HashEntry(object, true);
        ++this.currentSize;
        ++this.occupied;
        ++this.modCount;
        if (this.occupied > this.array.length / 2) {
            this.rehash();
        }
        return true;
    }

    private void rehash() {
        HashEntry[] hashEntryArray = this.array;
        this.allocateArray(HashSet.nextPrime(4 * this.size()));
        this.currentSize = 0;
        this.occupied = 0;
        int n = 0;
        while (n < hashEntryArray.length) {
            if (HashSet.isActive(hashEntryArray, n)) {
                this.add(hashEntryArray[n].element);
            }
            ++n;
        }
    }

    public boolean remove(Object object) {
        int n = this.findPos(object);
        if (!HashSet.isActive(this.array, n)) {
            return false;
        }
        this.array[n].isActive = false;
        --this.currentSize;
        ++this.modCount;
        if (this.currentSize < this.array.length / 8) {
            this.rehash();
        }
        return true;
    }

    public void clear() {
        this.occupied = 0;
        this.currentSize = 0;
        ++this.modCount;
        int n = 0;
        while (n < this.array.length) {
            this.array[n] = null;
            ++n;
        }
    }

    public Iterator iterator() {
        return new HashSetIterator();
    }

    private int findPos(Object object) {
        int n = 0;
        int n2 = object == null ? 0 : Math.abs(object.hashCode() % this.array.length);
        while (this.array[n2] != null) {
            if (object != null ? object.equals(this.array[n2].element) : this.array[n2].element == null) break;
            if ((n2 += 2 * ++n - 1) < this.array.length) continue;
            n2 -= this.array.length;
        }
        return n2;
    }

    private void allocateArray(int n) {
        this.array = new HashEntry[n];
    }

    private static int nextPrime(int n) {
        if (n % 2 == 0) {
            ++n;
        }
        while (!HashSet.isPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isPrime(int n) {
        if (n == 2 || n == 3) {
            return true;
        }
        if (n == 1 || n % 2 == 0) {
            return false;
        }
        int n2 = 3;
        while (n2 * n2 <= n) {
            if (n % n2 == 0) {
                return false;
            }
            n2 += 2;
        }
        return true;
    }

    private static class HashEntry
    implements Serializable {
        public Object element;
        public boolean isActive;

        public HashEntry(Object object) {
            this(object, true);
        }

        public HashEntry(Object object, boolean bl) {
            this.element = object;
            this.isActive = bl;
        }
    }

    private class HashSetIterator
    implements Iterator {
        private int expectedModCount;
        private int currentPos;
        private int visited;

        private HashSetIterator() {
            this.expectedModCount = HashSet.this.modCount;
            this.currentPos = -1;
            this.visited = 0;
        }

        public boolean hasNext() {
            if (this.expectedModCount != HashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.visited != HashSet.this.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            do {
                ++this.currentPos;
            } while (this.currentPos < HashSet.this.array.length && !HashSet.isActive(HashSet.this.array, this.currentPos));
            ++this.visited;
            return ((HashSet)HashSet.this).array[this.currentPos].element;
        }

        public void remove() {
            if (this.expectedModCount != HashSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.currentPos == -1 || !HashSet.isActive(HashSet.this.array, this.currentPos)) {
                throw new IllegalStateException();
            }
            ((HashSet)HashSet.this).array[this.currentPos].isActive = false;
            HashSet.this.currentSize--;
            --this.visited;
            HashSet.this.modCount++;
            ++this.expectedModCount;
        }
    }
}

