/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.ConcurrentModificationException;
import weiss.util.Iterator;
import weiss.util.List;
import weiss.util.ListIterator;
import weiss.util.NoSuchElementException;

public class LinkedList
extends AbstractCollection
implements List {
    private static final Node NOT_FOUND = null;
    private int theSize;
    private Node beginMarker;
    private Node endMarker;
    private int modCount = 0;

    public LinkedList() {
        this.clear();
    }

    public LinkedList(Collection collection) {
        this.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public int size() {
        return this.theSize;
    }

    public boolean contains(Object object) {
        return this.findPos(object) != NOT_FOUND;
    }

    private Node findPos(Object object) {
        Node node = this.beginMarker.next;
        while (node != this.endMarker) {
            if (object == null ? node.data == null : object.equals(node.data)) {
                return node;
            }
            node = node.next;
        }
        return NOT_FOUND;
    }

    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    public void add(int n, Object object) {
        Node node;
        Node node2 = this.getNode(n);
        node.prev.next = node = new Node(object, node2.prev, node2);
        node2.prev = node;
        ++this.theSize;
        ++this.modCount;
    }

    public void addFirst(Object object) {
        this.add(0, object);
    }

    public void addLast(Object object) {
        this.add(this.size(), object);
    }

    public Object getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getNode((int)0).data;
    }

    public Object getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getNode((int)(this.size() - 1)).data;
    }

    public Object removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.remove(this.getNode(0));
    }

    public Object removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.remove(this.getNode(this.size() - 1));
    }

    public boolean remove(Object object) {
        Node node = this.findPos(object);
        if (node == NOT_FOUND) {
            return false;
        }
        this.remove(node);
        return true;
    }

    public Object get(int n) {
        return this.getNode((int)n).data;
    }

    public Object set(int n, Object object) {
        Node node = this.getNode(n);
        Object object2 = node.data;
        node.data = object;
        return object2;
    }

    private Node getNode(int n) {
        Node node;
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("getNode index: " + n + "; size: " + this.size());
        }
        if (n < this.size() / 2) {
            node = this.beginMarker.next;
            int n2 = 0;
            while (n2 < n) {
                node = node.next;
                ++n2;
            }
        } else {
            node = this.endMarker;
            int n3 = this.size();
            while (n3 > n) {
                node = node.prev;
                --n3;
            }
        }
        return node;
    }

    public Object remove(int n) {
        return this.remove(this.getNode(n));
    }

    private Object remove(Node node) {
        node.next.prev = node.prev;
        node.prev.next = node.next;
        --this.theSize;
        ++this.modCount;
        return node.data;
    }

    public void clear() {
        this.beginMarker = new Node("BEGINMARKER", null, null);
        this.beginMarker.next = this.endMarker = new Node("ENDMARKER", this.beginMarker, null);
        this.theSize = 0;
        ++this.modCount;
    }

    public Iterator iterator() {
        return new LinkedListIterator(0);
    }

    public ListIterator listIterator(int n) {
        return new LinkedListIterator(n);
    }

    private static class Node {
        public Object data;
        public Node prev;
        public Node next;

        public Node(Object object, Node node, Node node2) {
            this.data = object;
            this.prev = node;
            this.next = node2;
        }
    }

    private class LinkedListIterator
    implements ListIterator {
        private Node current;
        private Node lastVisited = null;
        private boolean lastMoveWasPrev = false;
        private int expectedModCount = LinkedList.access$000(LinkedList.this);

        public LinkedListIterator(int n) {
            this.current = LinkedList.this.getNode(n);
        }

        public boolean hasNext() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current != LinkedList.this.endMarker;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.current.data;
            this.lastVisited = this.current;
            this.current = this.current.next;
            this.lastMoveWasPrev = false;
            return object;
        }

        public void remove() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastVisited == null) {
                throw new IllegalStateException();
            }
            LinkedList.this.remove(this.lastVisited);
            this.lastVisited = null;
            if (this.lastMoveWasPrev) {
                this.current = this.current.next;
            }
            ++this.expectedModCount;
        }

        public boolean hasPrevious() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.current != ((LinkedList)LinkedList.this).beginMarker.next;
        }

        public Object previous() {
            if (this.expectedModCount != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastVisited = this.current = this.current.prev;
            this.lastMoveWasPrev = true;
            return this.current.data;
        }
    }
}

