/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

public class Random {
    private static final int A = 48271;
    private static final int M = Integer.MAX_VALUE;
    private static final int Q = 44488;
    private static final int R = 3399;
    private int state;

    public Random() {
        this((int)(System.currentTimeMillis() % Integer.MAX_VALUE));
    }

    public Random(int n) {
        if (n < 0) {
            n += Integer.MAX_VALUE;
        }
        this.state = n;
        if (this.state == 0) {
            this.state = 1;
        }
    }

    public int nextInt() {
        int n = 48271 * (this.state % 44488) - 3399 * (this.state / 44488);
        this.state = n >= 0 ? n : n + Integer.MAX_VALUE;
        return this.state;
    }

    public int nextInt(int n) {
        return this.nextInt() % n;
    }

    public int nextIntWRONG() {
        this.state = 48271 * this.state % Integer.MAX_VALUE;
        return this.state;
    }

    public double nextDouble() {
        return (double)this.nextInt() / 2.147483647E9;
    }

    public int nextInt(int n, int n2) {
        double d = 2.147483647E9 / (double)(n2 - n + 1);
        return (int)((double)this.nextInt() / d) + n;
    }

    public long nextLong() {
        return ((long)this.nextInt() << 31) + (long)this.nextInt();
    }

    public long nextLong(long l, long l2) {
        long l3 = ((long)this.nextInt() << 31) + (long)this.nextInt();
        long l4 = 0x3FFFFFFFFFFFFFFFL;
        double d = (double)l4 / (double)(l2 - l + 1L);
        return (long)((double)l3 / d) + l;
    }

    public int nextPoisson(double d) {
        double d2 = -d;
        double d3 = Math.log(this.nextDouble());
        int n = 0;
        while (d3 > d2) {
            d3 += Math.log(this.nextDouble());
            ++n;
        }
        return n;
    }

    public double nextNegExp(double d) {
        return -d * Math.log(this.nextDouble());
    }

    private static final void swapReferences(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static final void permute(Object[] objectArray) {
        Random random = new Random();
        int n = 1;
        while (n < objectArray.length) {
            Random.swapReferences(objectArray, n, random.nextInt(0, n));
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        Random random = new Random();
        int n = 0;
        while (n < 20) {
            System.out.println(random.nextInt());
            ++n;
        }
        int[] nArray = new int[10000];
        int n2 = 0;
        while (n2 < 1000000) {
            int n3 = random.nextPoisson(2.0);
            nArray[n3] = nArray[n3] + 1;
            ++n2;
        }
        int n4 = 0;
        while (n4 < 10) {
            System.out.println(n4 + ": " + (double)nArray[n4] / 1000000.0);
            ++n4;
        }
    }
}

