/*
 * Decompiled with CFR 0.152.
 */
package weiss.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import weiss.util.AbstractCollection;
import weiss.util.Collection;
import weiss.util.Collections;
import weiss.util.Comparator;
import weiss.util.ConcurrentModificationException;
import weiss.util.Iterator;
import weiss.util.NoSuchElementException;
import weiss.util.SortedSet;
import weiss.util.Stack;

public class TreeSet
extends AbstractCollection
implements SortedSet {
    private int modCount = 0;
    private int theSize = 0;
    private AANode root = nullNode;
    private Comparator cmp = Collections.DEFAULT_COMPARATOR;
    private static AANode nullNode;
    private static AANode deletedNode;
    private static AANode lastNode;

    public TreeSet() {
    }

    public TreeSet(Comparator comparator) {
        this();
        this.cmp = comparator;
    }

    public TreeSet(TreeSet treeSet) {
        this();
        this.cmp = treeSet.cmp;
        this.copyFrom(treeSet);
    }

    public TreeSet(Collection collection) {
        this();
        this.copyFrom(collection);
    }

    public Comparator comparator() {
        if (this.cmp == Collections.DEFAULT_COMPARATOR) {
            return null;
        }
        return this.cmp;
    }

    private void copyFrom(Collection collection) {
        this.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public int size() {
        return this.theSize;
    }

    public Object first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        AANode aANode = this.root;
        while (aANode.left != nullNode) {
            aANode = aANode.left;
        }
        return aANode.element;
    }

    public Object last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        AANode aANode = this.root;
        while (aANode.right != nullNode) {
            aANode = aANode.right;
        }
        return aANode.element;
    }

    public Object getMatch(Object object) {
        AANode aANode = this.find(object);
        if (aANode == null) {
            return null;
        }
        return aANode.element;
    }

    private AANode find(Object object) {
        AANode aANode = this.root;
        TreeSet.nullNode.element = object;
        while (true) {
            if (this.cmp.compare(object, aANode.element) < 0) {
                aANode = aANode.left;
                continue;
            }
            if (this.cmp.compare(object, aANode.element) <= 0) break;
            aANode = aANode.right;
        }
        if (aANode != nullNode) {
            return aANode;
        }
        return null;
    }

    public boolean contains(Object object) {
        return this.getMatch(object) != null;
    }

    public boolean add(Object object) {
        int n = this.size();
        this.root = this.insert(object, this.root);
        return this.size() != n;
    }

    private AANode insert(Object object, AANode aANode) {
        if (aANode == nullNode) {
            aANode = new AANode(object, nullNode, nullNode);
            ++this.modCount;
            ++this.theSize;
        } else if (this.cmp.compare(object, aANode.element) < 0) {
            aANode.left = this.insert(object, aANode.left);
        } else if (this.cmp.compare(object, aANode.element) > 0) {
            aANode.right = this.insert(object, aANode.right);
        } else {
            return aANode;
        }
        aANode = this.skew(aANode);
        aANode = this.split(aANode);
        return aANode;
    }

    public boolean remove(Object object) {
        int n = this.size();
        deletedNode = nullNode;
        this.root = this.remove(object, this.root);
        return this.size() != n;
    }

    private AANode remove(Object object, AANode aANode) {
        if (aANode != nullNode) {
            lastNode = aANode;
            if (this.cmp.compare(object, aANode.element) < 0) {
                aANode.left = this.remove(object, aANode.left);
            } else {
                deletedNode = aANode;
                aANode.right = this.remove(object, aANode.right);
            }
            if (aANode == lastNode) {
                if (deletedNode == nullNode || this.cmp.compare(object, TreeSet.deletedNode.element) != 0) {
                    return aANode;
                }
                TreeSet.deletedNode.element = aANode.element;
                aANode = aANode.right;
                --this.theSize;
                ++this.modCount;
            } else if (aANode.left.level < aANode.level - 1 || aANode.right.level < aANode.level - 1) {
                if (aANode.right.level > --aANode.level) {
                    aANode.right.level = aANode.level;
                }
                aANode = this.skew(aANode);
                aANode.right = this.skew(aANode.right);
                aANode.right.right = this.skew(aANode.right.right);
                aANode = this.split(aANode);
                aANode.right = this.split(aANode.right);
            }
        }
        return aANode;
    }

    public void clear() {
        this.theSize = 0;
        ++this.modCount;
        this.root = nullNode;
    }

    public Iterator iterator() {
        return new TreeSetIterator();
    }

    private AANode skew(AANode aANode) {
        if (aANode.left.level == aANode.level) {
            aANode = TreeSet.rotateWithLeftChild(aANode);
        }
        return aANode;
    }

    private AANode split(AANode aANode) {
        if (aANode.right.right.level == aANode.level) {
            aANode = TreeSet.rotateWithRightChild(aANode);
            ++aANode.level;
        }
        return aANode;
    }

    private static AANode rotateWithLeftChild(AANode aANode) {
        AANode aANode2 = aANode.left;
        aANode.left = aANode2.right;
        aANode2.right = aANode;
        return aANode2;
    }

    private static AANode rotateWithRightChild(AANode aANode) {
        AANode aANode2 = aANode.right;
        aANode.right = aANode2.left;
        aANode2.left = aANode;
        return aANode2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(nullNode);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        nullNode = (AANode)objectInputStream.readObject();
    }

    static {
        TreeSet.nullNode.left = TreeSet.nullNode.right = (nullNode = new AANode("NULLNODE"));
        TreeSet.nullNode.level = 0;
    }

    private static class AANode
    implements Serializable {
        public Object element;
        public AANode left;
        public AANode right;
        public int level;

        public AANode(Object object) {
            this(object, nullNode, nullNode);
        }

        public AANode(Object object, AANode aANode, AANode aANode2) {
            this.element = object;
            this.left = aANode;
            this.right = aANode2;
            this.level = 1;
        }
    }

    private class TreeSetIterator
    implements Iterator {
        private int expectedModCount;
        private int visited;
        private Stack path;
        private AANode current;
        private AANode lastVisited;

        public TreeSetIterator() {
            this.expectedModCount = TreeSet.this.modCount;
            this.visited = 0;
            this.path = new Stack();
            this.current = null;
            this.lastVisited = null;
            if (TreeSet.this.isEmpty()) {
                return;
            }
            AANode aANode = null;
            aANode = TreeSet.this.root;
            while (aANode.left != nullNode) {
                this.path.push(aANode);
                aANode = aANode.left;
            }
            this.current = aANode;
        }

        public boolean hasNext() {
            if (this.expectedModCount != TreeSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.visited < TreeSet.this.size();
        }

        /*
         * Unable to fully structure code
         */
        public Object next() {
            block4: {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                var1_1 = this.current.element;
                this.lastVisited = this.current;
                if (this.current.right == TreeSet.access$200()) ** GOTO lbl20
                this.path.push(this.current);
                this.current = this.current.right;
                while (this.current.left != TreeSet.access$200()) {
                    this.path.push(this.current);
                    this.current = this.current.left;
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    var2_2 = (AANode)this.path.pop();
                    if (var2_2.left == this.current) {
                        this.current = var2_2;
                        break;
                    }
                    this.current = var2_2;
lbl20:
                    // 2 sources

                    ** while (!this.path.isEmpty())
                }
            }
            ++this.visited;
            return var1_1;
        }

        public void remove() {
            if (this.expectedModCount != TreeSet.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastVisited == null) {
                throw new IllegalStateException();
            }
            Object object = this.lastVisited.element;
            TreeSet.this.remove(object);
            ++this.expectedModCount;
            --this.visited;
            this.lastVisited = null;
            if (!this.hasNext()) {
                return;
            }
            Object object2 = this.current.element;
            this.path.clear();
            AANode aANode = TreeSet.this.root;
            while (true) {
                this.path.push(aANode);
                if (TreeSet.this.cmp.compare(object2, aANode.element) < 0) {
                    aANode = aANode.left;
                    continue;
                }
                if (TreeSet.this.cmp.compare(object2, aANode.element) <= 0) break;
                aANode = aANode.right;
            }
            this.path.pop();
            this.current = aANode;
        }
    }
}

