/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.DuplicateItemException;
import weiss.nonstandard.ItemNotFoundException;

public class AATree {
    private AANode root = nullNode;
    private static AANode nullNode;
    private static AANode deletedNode;
    private static AANode lastNode;

    public void insert(Comparable comparable) {
        this.root = this.insert(comparable, this.root);
    }

    public void remove(Comparable comparable) {
        deletedNode = nullNode;
        this.root = this.remove(comparable, this.root);
    }

    public Comparable findMin() {
        if (this.isEmpty()) {
            return null;
        }
        AANode aANode = this.root;
        while (aANode.left != nullNode) {
            aANode = aANode.left;
        }
        return aANode.element;
    }

    public Comparable findMax() {
        if (this.isEmpty()) {
            return null;
        }
        AANode aANode = this.root;
        while (aANode.right != nullNode) {
            aANode = aANode.right;
        }
        return aANode.element;
    }

    public Comparable find(Comparable comparable) {
        AANode aANode = this.root;
        AATree.nullNode.element = comparable;
        while (true) {
            if (comparable.compareTo(aANode.element) < 0) {
                aANode = aANode.left;
                continue;
            }
            if (comparable.compareTo(aANode.element) <= 0) break;
            aANode = aANode.right;
        }
        if (aANode != nullNode) {
            return aANode.element;
        }
        return null;
    }

    public void makeEmpty() {
        this.root = nullNode;
    }

    public boolean isEmpty() {
        return this.root == nullNode;
    }

    private AANode insert(Comparable comparable, AANode aANode) {
        if (aANode == nullNode) {
            aANode = new AANode(comparable);
        } else if (comparable.compareTo(aANode.element) < 0) {
            aANode.left = this.insert(comparable, aANode.left);
        } else if (comparable.compareTo(aANode.element) > 0) {
            aANode.right = this.insert(comparable, aANode.right);
        } else {
            throw new DuplicateItemException(comparable.toString());
        }
        aANode = AATree.skew(aANode);
        aANode = AATree.split(aANode);
        return aANode;
    }

    private AANode remove(Comparable comparable, AANode aANode) {
        if (aANode != nullNode) {
            lastNode = aANode;
            if (comparable.compareTo(aANode.element) < 0) {
                aANode.left = this.remove(comparable, aANode.left);
            } else {
                deletedNode = aANode;
                aANode.right = this.remove(comparable, aANode.right);
            }
            if (aANode == lastNode) {
                if (deletedNode == nullNode || comparable.compareTo(AATree.deletedNode.element) != 0) {
                    throw new ItemNotFoundException(comparable.toString());
                }
                AATree.deletedNode.element = aANode.element;
                aANode = aANode.right;
            } else if (aANode.left.level < aANode.level - 1 || aANode.right.level < aANode.level - 1) {
                if (aANode.right.level > --aANode.level) {
                    aANode.right.level = aANode.level;
                }
                aANode = AATree.skew(aANode);
                aANode.right = AATree.skew(aANode.right);
                aANode.right.right = AATree.skew(aANode.right.right);
                aANode = AATree.split(aANode);
                aANode.right = AATree.split(aANode.right);
            }
        }
        return aANode;
    }

    private static AANode skew(AANode aANode) {
        if (aANode.left.level == aANode.level) {
            aANode = AATree.rotateWithLeftChild(aANode);
        }
        return aANode;
    }

    private static AANode split(AANode aANode) {
        if (aANode.right.right.level == aANode.level) {
            aANode = AATree.rotateWithRightChild(aANode);
            ++aANode.level;
        }
        return aANode;
    }

    private static AANode rotateWithLeftChild(AANode aANode) {
        AANode aANode2 = aANode.left;
        aANode.left = aANode2.right;
        aANode2.right = aANode;
        return aANode2;
    }

    private static AANode rotateWithRightChild(AANode aANode) {
        AANode aANode2 = aANode.right;
        aANode.right = aANode2.left;
        aANode2.left = aANode;
        return aANode2;
    }

    public static void main(String[] stringArray) {
        AATree aATree = new AATree();
        System.out.println("Checking... (no bad output means success)");
        int n = 307;
        while (n != 0) {
            aATree.insert(new Integer(n));
            n = (n + 307) % 40000;
        }
        System.out.println("Inserts complete");
        int n2 = 1;
        while (n2 < 40000) {
            aATree.remove(new Integer(n2));
            n2 += 2;
        }
        System.out.println("Removes complete");
        if ((Integer)aATree.findMin() != 2 || (Integer)aATree.findMax() != 39998) {
            System.out.println("FindMin or FindMax error!");
        }
        int n3 = 2;
        while (n3 < 40000) {
            if ((Integer)aATree.find(new Integer(n3)) != n3) {
                System.out.println("Error: find fails for " + n3);
            }
            n3 += 2;
        }
        int n4 = 1;
        while (n4 < 40000) {
            if (aATree.find(new Integer(n4)) != null) {
                System.out.println("Error: Found deleted item " + n4);
            }
            n4 += 2;
        }
    }

    static {
        AATree.nullNode.left = AATree.nullNode.right = (nullNode = new AANode(null));
        AATree.nullNode.level = 0;
    }

    private static class AANode {
        Comparable element;
        AANode left;
        AANode right;
        int level;

        AANode(Comparable comparable) {
            this.element = comparable;
            this.left = this.right = nullNode;
            this.level = 1;
        }
    }
}

