/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.Queue;
import weiss.nonstandard.UnderflowException;

public class ArrayQueue
implements Queue {
    private Object[] theArray = new Object[10];
    private int currentSize;
    private int front;
    private int back;
    private static final int DEFAULT_CAPACITY = 10;

    public ArrayQueue() {
        this.makeEmpty();
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public void makeEmpty() {
        this.currentSize = 0;
        this.front = 0;
        this.back = -1;
    }

    public Object dequeue() {
        if (this.isEmpty()) {
            throw new UnderflowException("ArrayQueue dequeue");
        }
        --this.currentSize;
        Object object = this.theArray[this.front];
        this.front = this.increment(this.front);
        return object;
    }

    public Object getFront() {
        if (this.isEmpty()) {
            throw new UnderflowException("ArrayQueue getFront");
        }
        return this.theArray[this.front];
    }

    public void enqueue(Object object) {
        if (this.currentSize == this.theArray.length) {
            this.doubleQueue();
        }
        this.back = this.increment(this.back);
        this.theArray[this.back] = object;
        ++this.currentSize;
    }

    private int increment(int n) {
        if (++n == this.theArray.length) {
            n = 0;
        }
        return n;
    }

    private void doubleQueue() {
        Object[] objectArray = new Object[this.theArray.length * 2];
        int n = 0;
        while (n < this.currentSize) {
            objectArray[n] = this.theArray[this.front];
            ++n;
            this.front = this.increment(this.front);
        }
        this.theArray = objectArray;
        this.front = 0;
        this.back = this.currentSize - 1;
    }
}

