/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.PriorityQueue;
import weiss.nonstandard.UnderflowException;

public class BinaryHeap
implements PriorityQueue {
    private static final int DEFAULT_CAPACITY = 100;
    private int currentSize;
    private Comparable[] array;

    public BinaryHeap() {
        this.currentSize = 0;
        this.array = new Comparable[101];
    }

    public BinaryHeap(Comparable[] comparableArray) {
        this.currentSize = comparableArray.length;
        this.array = new Comparable[comparableArray.length + 1];
        int n = 0;
        while (n < comparableArray.length) {
            this.array[n + 1] = comparableArray[n];
            ++n;
        }
        this.buildHeap();
    }

    public PriorityQueue.Position insert(Comparable comparable) {
        if (this.currentSize + 1 == this.array.length) {
            this.doubleArray();
        }
        int n = ++this.currentSize;
        this.array[0] = comparable;
        while (comparable.compareTo(this.array[n / 2]) < 0) {
            this.array[n] = this.array[n / 2];
            n /= 2;
        }
        this.array[n] = comparable;
        return null;
    }

    public void decreaseKey(PriorityQueue.Position position, Comparable comparable) {
        throw new UnsupportedOperationException("Cannot use decreaseKey for binary heap");
    }

    public Comparable findMin() {
        if (this.isEmpty()) {
            throw new UnderflowException("Empty binary heap");
        }
        return this.array[1];
    }

    public Comparable deleteMin() {
        Comparable comparable = this.findMin();
        this.array[1] = this.array[this.currentSize--];
        this.percolateDown(1);
        return comparable;
    }

    private void buildHeap() {
        int n = this.currentSize / 2;
        while (n > 0) {
            this.percolateDown(n);
            --n;
        }
    }

    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    public int size() {
        return this.currentSize;
    }

    public void makeEmpty() {
        this.currentSize = 0;
    }

    private void percolateDown(int n) {
        Comparable comparable = this.array[n];
        while (n * 2 <= this.currentSize) {
            int n2 = n * 2;
            if (n2 != this.currentSize && this.array[n2 + 1].compareTo(this.array[n2]) < 0) {
                ++n2;
            }
            if (this.array[n2].compareTo(comparable) >= 0) break;
            this.array[n] = this.array[n2];
            n = n2;
        }
        this.array[n] = comparable;
    }

    private void doubleArray() {
        Comparable[] comparableArray = new Comparable[this.array.length * 2];
        int n = 0;
        while (n < this.array.length) {
            comparableArray[n] = this.array[n];
            ++n;
        }
        this.array = comparableArray;
    }

    public static void main(String[] stringArray) {
        int n = 10000;
        BinaryHeap binaryHeap = new BinaryHeap();
        Comparable[] comparableArray = new Integer[n - 1];
        int n2 = 37;
        n2 = 37;
        int n3 = 0;
        while (n2 != 0) {
            binaryHeap.insert(new Integer(n2));
            comparableArray[n3] = new Integer(n2);
            n2 = (n2 + 37) % n;
            ++n3;
        }
        n2 = 1;
        while (n2 < n) {
            if ((Integer)binaryHeap.deleteMin() != n2) {
                System.out.println("Oops! " + n2);
            }
            ++n2;
        }
        BinaryHeap binaryHeap2 = new BinaryHeap(comparableArray);
        n2 = 1;
        while (n2 < n) {
            if ((Integer)binaryHeap2.deleteMin() != n2) {
                System.out.println("Oops! " + n2);
            }
            ++n2;
        }
    }
}

