/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.BinaryNode;
import weiss.nonstandard.DuplicateItemException;
import weiss.nonstandard.ItemNotFoundException;

public class BinarySearchTree {
    protected BinaryNode root = null;

    public void insert(Comparable comparable) {
        this.root = this.insert(comparable, this.root);
    }

    public void remove(Comparable comparable) {
        this.root = this.remove(comparable, this.root);
    }

    public void removeMin() {
        this.root = this.removeMin(this.root);
    }

    public Comparable findMin() {
        return this.elementAt(this.findMin(this.root));
    }

    public Comparable findMax() {
        return this.elementAt(this.findMax(this.root));
    }

    public Comparable find(Comparable comparable) {
        return this.elementAt(this.find(comparable, this.root));
    }

    public void makeEmpty() {
        this.root = null;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    private Comparable elementAt(BinaryNode binaryNode) {
        return binaryNode == null ? null : binaryNode.element;
    }

    protected BinaryNode insert(Comparable comparable, BinaryNode binaryNode) {
        if (binaryNode == null) {
            binaryNode = new BinaryNode(comparable);
        } else if (comparable.compareTo(binaryNode.element) < 0) {
            binaryNode.left = this.insert(comparable, binaryNode.left);
        } else if (comparable.compareTo(binaryNode.element) > 0) {
            binaryNode.right = this.insert(comparable, binaryNode.right);
        } else {
            throw new DuplicateItemException(comparable.toString());
        }
        return binaryNode;
    }

    protected BinaryNode remove(Comparable comparable, BinaryNode binaryNode) {
        if (binaryNode == null) {
            throw new ItemNotFoundException(comparable.toString());
        }
        if (comparable.compareTo(binaryNode.element) < 0) {
            binaryNode.left = this.remove(comparable, binaryNode.left);
        } else if (comparable.compareTo(binaryNode.element) > 0) {
            binaryNode.right = this.remove(comparable, binaryNode.right);
        } else if (binaryNode.left != null && binaryNode.right != null) {
            binaryNode.element = this.findMin((BinaryNode)binaryNode.right).element;
            binaryNode.right = this.removeMin(binaryNode.right);
        } else {
            binaryNode = binaryNode.left != null ? binaryNode.left : binaryNode.right;
        }
        return binaryNode;
    }

    protected BinaryNode removeMin(BinaryNode binaryNode) {
        if (binaryNode == null) {
            throw new ItemNotFoundException();
        }
        if (binaryNode.left != null) {
            binaryNode.left = this.removeMin(binaryNode.left);
            return binaryNode;
        }
        return binaryNode.right;
    }

    protected BinaryNode findMin(BinaryNode binaryNode) {
        if (binaryNode != null) {
            while (binaryNode.left != null) {
                binaryNode = binaryNode.left;
            }
        }
        return binaryNode;
    }

    private BinaryNode findMax(BinaryNode binaryNode) {
        if (binaryNode != null) {
            while (binaryNode.right != null) {
                binaryNode = binaryNode.right;
            }
        }
        return binaryNode;
    }

    private BinaryNode find(Comparable comparable, BinaryNode binaryNode) {
        while (binaryNode != null) {
            if (comparable.compareTo(binaryNode.element) < 0) {
                binaryNode = binaryNode.left;
                continue;
            }
            if (comparable.compareTo(binaryNode.element) > 0) {
                binaryNode = binaryNode.right;
                continue;
            }
            return binaryNode;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        BinarySearchTree binarySearchTree = new BinarySearchTree();
        System.out.println("Checking... (no more output means success)");
        int n = 37;
        while (n != 0) {
            binarySearchTree.insert(new Integer(n));
            n = (n + 37) % 4000;
        }
        int n2 = 1;
        while (n2 < 4000) {
            binarySearchTree.remove(new Integer(n2));
            n2 += 2;
        }
        if ((Integer)binarySearchTree.findMin() != 2 || (Integer)binarySearchTree.findMax() != 3998) {
            System.out.println("FindMin or FindMax error!");
        }
        int n3 = 2;
        while (n3 < 4000) {
            if ((Integer)binarySearchTree.find(new Integer(n3)) != n3) {
                System.out.println("Find error1!");
            }
            n3 += 2;
        }
        int n4 = 1;
        while (n4 < 4000) {
            if (binarySearchTree.find(new Integer(n4)) != null) {
                System.out.println("Find error2!");
            }
            n4 += 2;
        }
    }
}

