/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.BinaryNode;
import weiss.nonstandard.BinaryNodeWithSize;
import weiss.nonstandard.BinarySearchTree;
import weiss.nonstandard.DuplicateItemException;
import weiss.nonstandard.ItemNotFoundException;

public class BinarySearchTreeWithRank
extends BinarySearchTree {
    public Comparable findKth(int n) {
        return this.findKth((int)n, (BinaryNode)this.root).element;
    }

    protected BinaryNode findKth(int n, BinaryNode binaryNode) {
        int n2;
        if (binaryNode == null) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 = binaryNode.left != null ? ((BinaryNodeWithSize)binaryNode.left).size : 0;
        if (n <= n2) {
            return this.findKth(n, binaryNode.left);
        }
        if (n == n2 + 1) {
            return binaryNode;
        }
        return this.findKth(n - n2 - 1, binaryNode.right);
    }

    protected BinaryNode insert(Comparable comparable, BinaryNode binaryNode) {
        BinaryNodeWithSize binaryNodeWithSize = (BinaryNodeWithSize)binaryNode;
        if (binaryNodeWithSize == null) {
            binaryNodeWithSize = new BinaryNodeWithSize(comparable);
        } else if (comparable.compareTo(binaryNodeWithSize.element) < 0) {
            binaryNodeWithSize.left = this.insert(comparable, binaryNodeWithSize.left);
        } else if (comparable.compareTo(binaryNodeWithSize.element) > 0) {
            binaryNodeWithSize.right = this.insert(comparable, binaryNodeWithSize.right);
        } else {
            throw new DuplicateItemException(comparable.toString());
        }
        ++binaryNodeWithSize.size;
        return binaryNodeWithSize;
    }

    protected BinaryNode remove(Comparable comparable, BinaryNode binaryNode) {
        BinaryNodeWithSize binaryNodeWithSize = (BinaryNodeWithSize)binaryNode;
        if (binaryNodeWithSize == null) {
            throw new ItemNotFoundException(comparable.toString());
        }
        if (comparable.compareTo(binaryNodeWithSize.element) < 0) {
            binaryNodeWithSize.left = this.remove(comparable, binaryNodeWithSize.left);
        } else if (comparable.compareTo(binaryNodeWithSize.element) > 0) {
            binaryNodeWithSize.right = this.remove(comparable, binaryNodeWithSize.right);
        } else if (binaryNodeWithSize.left != null && binaryNodeWithSize.right != null) {
            binaryNodeWithSize.element = this.findMin((BinaryNode)binaryNodeWithSize.right).element;
            binaryNodeWithSize.right = this.removeMin(binaryNodeWithSize.right);
        } else {
            return binaryNodeWithSize.left != null ? binaryNodeWithSize.left : binaryNodeWithSize.right;
        }
        --binaryNodeWithSize.size;
        return binaryNodeWithSize;
    }

    protected BinaryNode removeMin(BinaryNode binaryNode) {
        BinaryNodeWithSize binaryNodeWithSize = (BinaryNodeWithSize)binaryNode;
        if (binaryNodeWithSize == null) {
            throw new ItemNotFoundException();
        }
        if (binaryNodeWithSize.left == null) {
            return binaryNodeWithSize.right;
        }
        binaryNodeWithSize.left = this.removeMin(binaryNodeWithSize.left);
        --binaryNodeWithSize.size;
        return binaryNodeWithSize;
    }

    public static void main(String[] stringArray) {
        BinarySearchTreeWithRank binarySearchTreeWithRank = new BinarySearchTreeWithRank();
        System.out.println("Checking... (no more output means success)");
        int n = 37;
        while (n != 0) {
            binarySearchTreeWithRank.insert(new Integer(n));
            n = (n + 37) % 4000;
        }
        int n2 = 1;
        while (n2 < 4000) {
            binarySearchTreeWithRank.remove(new Integer(n2));
            n2 += 2;
        }
        if ((Integer)binarySearchTreeWithRank.findMin() != 2 || (Integer)binarySearchTreeWithRank.findMax() != 3998) {
            System.out.println("FindMin or FindMax error!");
        }
        int n3 = 2;
        while (n3 < 4000) {
            if ((Integer)binarySearchTreeWithRank.find(new Integer(n3)) != n3) {
                System.out.println("Find error1!");
            }
            n3 += 2;
        }
        int n4 = 1;
        while (n4 < 4000) {
            if (binarySearchTreeWithRank.find(new Integer(n4)) != null) {
                System.out.println("Find error2!");
            }
            n4 += 2;
        }
        int n5 = 2;
        while (n5 < 4000) {
            if ((Integer)binarySearchTreeWithRank.findKth(n5 / 2) != n5) {
                System.out.println("FindKth error!");
            }
            n5 += 2;
        }
    }
}

