/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

public class DisjointSets {
    private int[] s;

    public DisjointSets(int n) {
        this.s = new int[n];
        int n2 = 0;
        while (n2 < this.s.length) {
            this.s[n2] = -1;
            ++n2;
        }
    }

    public void union(int n, int n2) {
        this.assertIsRoot(n);
        this.assertIsRoot(n2);
        if (n == n2) {
            throw new IllegalArgumentException("Union: root1 == root2 " + n);
        }
        if (this.s[n2] < this.s[n]) {
            this.s[n] = n2;
        } else {
            if (this.s[n] == this.s[n2]) {
                int n3 = n;
                this.s[n3] = this.s[n3] - 1;
            }
            this.s[n2] = n;
        }
    }

    public int find(int n) {
        this.assertIsItem(n);
        if (this.s[n] < 0) {
            return n;
        }
        this.s[n] = this.find(this.s[n]);
        return this.s[n];
    }

    private void assertIsRoot(int n) {
        this.assertIsItem(n);
        if (this.s[n] >= 0) {
            throw new IllegalArgumentException("Union: " + n + " not a root");
        }
    }

    private void assertIsItem(int n) {
        if (n < 0 || n >= this.s.length) {
            throw new IllegalArgumentException("Disjoint sets: " + n + " not an item");
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 128;
        int n3 = 16;
        DisjointSets disjointSets = new DisjointSets(n2);
        int n4 = 1;
        while (n4 < n3) {
            n = 0;
            while (n + n4 < n2) {
                int n5 = disjointSets.find(n);
                int n6 = disjointSets.find(n + n4);
                disjointSets.union(n5, n6);
                n += 2 * n4;
            }
            n4 *= 2;
        }
        n = 0;
        while (n < n2) {
            System.out.print(disjointSets.find(n) + "*");
            if (n % n3 == n3 - 1) {
                System.out.println();
            }
            ++n;
        }
        System.out.println();
    }
}

