/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

class DisjointSetsSlow {
    private int[] s;

    public DisjointSetsSlow(int n) {
        this.s = new int[n];
        int n2 = 0;
        while (n2 < this.s.length) {
            this.s[n2] = -1;
            ++n2;
        }
    }

    public void union(int n, int n2) {
        this.assertIsRoot(n);
        this.assertIsRoot(n2);
        if (n == n2) {
            throw new IllegalArgumentException("Union: root1 == root2 " + n);
        }
        this.s[n2] = n;
    }

    public int find(int n) {
        this.assertIsItem(n);
        if (this.s[n] < 0) {
            return n;
        }
        return this.find(this.s[n]);
    }

    private void assertIsRoot(int n) {
        this.assertIsItem(n);
        if (this.s[n] >= 0) {
            throw new IllegalArgumentException("Union: " + n + " not a root");
        }
    }

    private void assertIsItem(int n) {
        if (n < 0 || n >= this.s.length) {
            throw new IllegalArgumentException("Disjoint sets: " + n + " not an item");
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 128;
        int n3 = 16;
        DisjointSetsSlow disjointSetsSlow = new DisjointSetsSlow(n2);
        int n4 = 1;
        while (n4 < n3) {
            n = 0;
            while (n + n4 < n2) {
                int n5 = disjointSetsSlow.find(n);
                int n6 = disjointSetsSlow.find(n + n4);
                disjointSetsSlow.union(n5, n6);
                n += 2 * n4;
            }
            n4 *= 2;
        }
        n = 0;
        while (n < n2) {
            System.out.print(disjointSetsSlow.find(n) + "*");
            if (n % n3 == n3 - 1) {
                System.out.println();
            }
            ++n;
        }
        System.out.println();
    }
}

