/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.LinkedListIterator;
import weiss.nonstandard.ListNode;

public class LinkedList {
    private ListNode header = new ListNode(null);

    public boolean isEmpty() {
        return this.header.next == null;
    }

    public void makeEmpty() {
        this.header.next = null;
    }

    public LinkedListIterator zeroth() {
        return new LinkedListIterator(this.header);
    }

    public LinkedListIterator first() {
        return new LinkedListIterator(this.header.next);
    }

    public void insert(Object object, LinkedListIterator linkedListIterator) {
        if (linkedListIterator != null && linkedListIterator.current != null) {
            linkedListIterator.current.next = new ListNode(object, linkedListIterator.current.next);
        }
    }

    public LinkedListIterator find(Object object) {
        ListNode listNode = this.header.next;
        while (listNode != null && !listNode.element.equals(object)) {
            listNode = listNode.next;
        }
        return new LinkedListIterator(listNode);
    }

    public LinkedListIterator findPrevious(Object object) {
        ListNode listNode = this.header;
        while (listNode.next != null && !listNode.next.element.equals(object)) {
            listNode = listNode.next;
        }
        return new LinkedListIterator(listNode);
    }

    public void remove(Object object) {
        LinkedListIterator linkedListIterator = this.findPrevious(object);
        if (linkedListIterator.current.next != null) {
            linkedListIterator.current.next = linkedListIterator.current.next.next;
        }
    }

    public static void printList(LinkedList linkedList) {
        if (linkedList.isEmpty()) {
            System.out.print("Empty list");
        } else {
            LinkedListIterator linkedListIterator = linkedList.first();
            while (linkedListIterator.isValid()) {
                System.out.print(linkedListIterator.retrieve() + " ");
                linkedListIterator.advance();
            }
        }
        System.out.println();
    }

    public static int listSize(LinkedList linkedList) {
        int n = 0;
        LinkedListIterator linkedListIterator = linkedList.first();
        while (linkedListIterator.isValid()) {
            ++n;
            linkedListIterator.advance();
        }
        return n;
    }

    public static void main(String[] stringArray) {
        LinkedList linkedList = new LinkedList();
        LinkedListIterator linkedListIterator = linkedList.zeroth();
        LinkedList.printList(linkedList);
        int n = 0;
        while (n < 10) {
            linkedList.insert(new Integer(n), linkedListIterator);
            LinkedList.printList(linkedList);
            linkedListIterator.advance();
            ++n;
        }
        System.out.println("Size was: " + LinkedList.listSize(linkedList));
        n = 0;
        while (n < 10) {
            linkedList.remove(new Integer(n));
            n += 2;
        }
        n = 0;
        while (n < 10) {
            if (n % 2 == 0 == linkedList.find(new Integer(n)).isValid()) {
                System.out.println("Find fails!");
            }
            ++n;
        }
        System.out.println("Finished deletions");
        LinkedList.printList(linkedList);
    }
}

