/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.IllegalValueException;
import weiss.nonstandard.PriorityQueue;
import weiss.nonstandard.UnderflowException;

public class PairingHeap
implements PriorityQueue {
    private PairNode root = null;
    private int theSize = 0;
    private PairNode[] treeArray = new PairNode[5];

    public PriorityQueue.Position insert(Comparable comparable) {
        PairNode pairNode = new PairNode(comparable);
        this.root = this.root == null ? pairNode : this.compareAndLink(this.root, pairNode);
        ++this.theSize;
        return pairNode;
    }

    public Comparable findMin() {
        if (this.isEmpty()) {
            throw new UnderflowException("Pairing heap is empty");
        }
        return this.root.element;
    }

    public Comparable deleteMin() {
        if (this.isEmpty()) {
            throw new UnderflowException("Pairing heap is empty");
        }
        Comparable comparable = this.findMin();
        this.root = this.root.leftChild == null ? null : this.combineSiblings(this.root.leftChild);
        --this.theSize;
        return comparable;
    }

    public void decreaseKey(PriorityQueue.Position position, Comparable comparable) {
        if (position == null) {
            throw new IllegalArgumentException("null Position passed to decreaseKey");
        }
        PairNode pairNode = (PairNode)position;
        if (pairNode.element.compareTo(comparable) < 0) {
            throw new IllegalValueException("newVal/oldval: " + comparable + " /" + pairNode.element);
        }
        pairNode.element = comparable;
        if (pairNode != this.root) {
            if (pairNode.nextSibling != null) {
                pairNode.nextSibling.prev = pairNode.prev;
            }
            if (pairNode.prev.leftChild == pairNode) {
                pairNode.prev.leftChild = pairNode.nextSibling;
            } else {
                pairNode.prev.nextSibling = pairNode.nextSibling;
            }
            pairNode.nextSibling = null;
            this.root = this.compareAndLink(this.root, pairNode);
        }
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int size() {
        return this.theSize;
    }

    public void makeEmpty() {
        this.root = null;
        this.theSize = 0;
    }

    private PairNode compareAndLink(PairNode pairNode, PairNode pairNode2) {
        if (pairNode2 == null) {
            return pairNode;
        }
        if (pairNode2.element.compareTo(pairNode.element) < 0) {
            pairNode2.prev = pairNode.prev;
            pairNode.prev = pairNode2;
            pairNode.nextSibling = pairNode2.leftChild;
            if (pairNode.nextSibling != null) {
                pairNode.nextSibling.prev = pairNode;
            }
            pairNode2.leftChild = pairNode;
            return pairNode2;
        }
        pairNode2.prev = pairNode;
        pairNode.nextSibling = pairNode2.nextSibling;
        if (pairNode.nextSibling != null) {
            pairNode.nextSibling.prev = pairNode;
        }
        pairNode2.nextSibling = pairNode.leftChild;
        if (pairNode2.nextSibling != null) {
            pairNode2.nextSibling.prev = pairNode2;
        }
        pairNode.leftChild = pairNode2;
        return pairNode;
    }

    private PairNode[] doubleIfFull(PairNode[] pairNodeArray, int n) {
        if (n == pairNodeArray.length) {
            PairNode[] pairNodeArray2 = pairNodeArray;
            pairNodeArray = new PairNode[n * 2];
            int n2 = 0;
            while (n2 < n) {
                pairNodeArray[n2] = pairNodeArray2[n2];
                ++n2;
            }
        }
        return pairNodeArray;
    }

    private PairNode combineSiblings(PairNode pairNode) {
        if (pairNode.nextSibling == null) {
            return pairNode;
        }
        int n = 0;
        while (pairNode != null) {
            this.treeArray = this.doubleIfFull(this.treeArray, n);
            this.treeArray[n] = pairNode;
            pairNode.prev.nextSibling = null;
            pairNode = pairNode.nextSibling;
            ++n;
        }
        this.treeArray = this.doubleIfFull(this.treeArray, n);
        this.treeArray[n] = null;
        int n2 = 0;
        while (n2 + 1 < n) {
            this.treeArray[n2] = this.compareAndLink(this.treeArray[n2], this.treeArray[n2 + 1]);
            n2 += 2;
        }
        int n3 = n2 - 2;
        if (n3 == n - 3) {
            this.treeArray[n3] = this.compareAndLink(this.treeArray[n3], this.treeArray[n3 + 2]);
        }
        while (n3 >= 2) {
            this.treeArray[n3 - 2] = this.compareAndLink(this.treeArray[n3 - 2], this.treeArray[n3]);
            n3 -= 2;
        }
        return this.treeArray[0];
    }

    public static void main(String[] stringArray) {
        PairingHeap pairingHeap = new PairingHeap();
        int n = 10000;
        int n2 = 37;
        System.out.println("Checking; no bad output is good");
        n2 = 37;
        while (n2 != 0) {
            pairingHeap.insert(new Integer(n2));
            n2 = (n2 + 37) % n;
        }
        n2 = 1;
        while (n2 < n) {
            if ((Integer)pairingHeap.deleteMin() != n2) {
                System.out.println("Oops! " + n2);
            }
            ++n2;
        }
        PriorityQueue.Position[] positionArray = new PriorityQueue.Position[n];
        n2 = 0;
        int n3 = n / 2;
        while (n2 < n) {
            positionArray[n3] = pairingHeap.insert(new Integer(n3 + n));
            ++n2;
            n3 = (n3 + 71) % n;
        }
        n2 = 0;
        n3 = n / 2;
        while (n2 < n) {
            pairingHeap.decreaseKey(positionArray[n3], new Integer((Integer)positionArray[n3].getValue() - n));
            ++n2;
            n3 = (n3 + 53) % n;
        }
        n2 = -1;
        while (!pairingHeap.isEmpty()) {
            if ((Integer)pairingHeap.deleteMin() == ++n2) continue;
            System.out.println("Oops! " + n2 + " ");
        }
        System.out.println("Check completed");
    }

    private static class PairNode
    implements PriorityQueue.Position {
        public Comparable element;
        public PairNode leftChild;
        public PairNode nextSibling;
        public PairNode prev;

        public PairNode(Comparable comparable) {
            this.element = comparable;
            this.leftChild = null;
            this.nextSibling = null;
            this.prev = null;
        }

        public Comparable getValue() {
            return this.element;
        }
    }
}

