/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.DuplicateItemException;

public class RedBlackTree {
    private RedBlackNode header = new RedBlackNode(null);
    private static RedBlackNode nullNode;
    private static final int BLACK = 1;
    private static final int RED = 0;
    private static RedBlackNode current;
    private static RedBlackNode parent;
    private static RedBlackNode grand;
    private static RedBlackNode great;

    public RedBlackTree() {
        this.header.left = this.header.right = nullNode;
    }

    private final int compare(Comparable comparable, RedBlackNode redBlackNode) {
        if (redBlackNode == this.header) {
            return 1;
        }
        return comparable.compareTo(redBlackNode.element);
    }

    public void insert(Comparable comparable) {
        parent = grand = this.header;
        current = grand;
        RedBlackTree.nullNode.element = comparable;
        while (this.compare(comparable, current) != 0) {
            great = grand;
            grand = parent;
            parent = current;
            RedBlackNode redBlackNode = current = this.compare(comparable, current) < 0 ? RedBlackTree.current.left : RedBlackTree.current.right;
            if (RedBlackTree.current.left.color != 0 || RedBlackTree.current.right.color != 0) continue;
            this.handleReorient(comparable);
        }
        if (current != nullNode) {
            throw new DuplicateItemException(comparable.toString());
        }
        current = new RedBlackNode(comparable, nullNode, nullNode);
        if (this.compare(comparable, parent) < 0) {
            RedBlackTree.parent.left = current;
        } else {
            RedBlackTree.parent.right = current;
        }
        this.handleReorient(comparable);
    }

    public void remove(Comparable comparable) {
        throw new UnsupportedOperationException();
    }

    public Comparable findMin() {
        if (this.isEmpty()) {
            return null;
        }
        RedBlackNode redBlackNode = this.header.right;
        while (redBlackNode.left != nullNode) {
            redBlackNode = redBlackNode.left;
        }
        return redBlackNode.element;
    }

    public Comparable findMax() {
        if (this.isEmpty()) {
            return null;
        }
        RedBlackNode redBlackNode = this.header.right;
        while (redBlackNode.right != nullNode) {
            redBlackNode = redBlackNode.right;
        }
        return redBlackNode.element;
    }

    public Comparable find(Comparable comparable) {
        RedBlackTree.nullNode.element = comparable;
        current = this.header.right;
        while (true) {
            if (comparable.compareTo(RedBlackTree.current.element) < 0) {
                current = RedBlackTree.current.left;
                continue;
            }
            if (comparable.compareTo(RedBlackTree.current.element) <= 0) break;
            current = RedBlackTree.current.right;
        }
        if (current != nullNode) {
            return RedBlackTree.current.element;
        }
        return null;
    }

    public void makeEmpty() {
        this.header.right = nullNode;
    }

    public void printTree() {
        this.printTree(this.header.right);
    }

    private void printTree(RedBlackNode redBlackNode) {
        if (redBlackNode != nullNode) {
            this.printTree(redBlackNode.left);
            System.out.println(redBlackNode.element);
            this.printTree(redBlackNode.right);
        }
    }

    public boolean isEmpty() {
        return this.header.right == nullNode;
    }

    private void handleReorient(Comparable comparable) {
        RedBlackTree.current.color = 0;
        RedBlackTree.current.left.color = 1;
        RedBlackTree.current.right.color = 1;
        if (RedBlackTree.parent.color == 0) {
            RedBlackTree.grand.color = 0;
            if (this.compare(comparable, grand) < 0 != this.compare(comparable, parent) < 0) {
                parent = this.rotate(comparable, grand);
            }
            current = this.rotate(comparable, great);
            RedBlackTree.current.color = 1;
        }
        this.header.right.color = 1;
    }

    private RedBlackNode rotate(Comparable comparable, RedBlackNode redBlackNode) {
        if (this.compare(comparable, redBlackNode) < 0) {
            redBlackNode.left = this.compare(comparable, redBlackNode.left) < 0 ? RedBlackTree.rotateWithLeftChild(redBlackNode.left) : RedBlackTree.rotateWithRightChild(redBlackNode.left);
            return redBlackNode.left;
        }
        redBlackNode.right = this.compare(comparable, redBlackNode.right) < 0 ? RedBlackTree.rotateWithLeftChild(redBlackNode.right) : RedBlackTree.rotateWithRightChild(redBlackNode.right);
        return redBlackNode.right;
    }

    private static RedBlackNode rotateWithLeftChild(RedBlackNode redBlackNode) {
        RedBlackNode redBlackNode2 = redBlackNode.left;
        redBlackNode.left = redBlackNode2.right;
        redBlackNode2.right = redBlackNode;
        return redBlackNode2;
    }

    private static RedBlackNode rotateWithRightChild(RedBlackNode redBlackNode) {
        RedBlackNode redBlackNode2 = redBlackNode.right;
        redBlackNode.right = redBlackNode2.left;
        redBlackNode2.left = redBlackNode;
        return redBlackNode2;
    }

    public static void main(String[] stringArray) {
        RedBlackTree redBlackTree = new RedBlackTree();
        System.out.println("Checking... (no more output means success)");
        int n = 35461;
        while (n != 0) {
            redBlackTree.insert(new Integer(n));
            n = (n + 35461) % 400000;
        }
        if ((Integer)redBlackTree.findMin() != 1 || (Integer)redBlackTree.findMax() != 399999) {
            System.out.println("FindMin or FindMax error!");
        }
        int n2 = 1;
        while (n2 < 400000) {
            if ((Integer)redBlackTree.find(new Integer(n2)) != n2) {
                System.out.println("Find error1!");
            }
            ++n2;
        }
    }

    static {
        RedBlackTree.nullNode.left = RedBlackTree.nullNode.right = (nullNode = new RedBlackNode(null));
    }

    private static class RedBlackNode {
        Comparable element;
        RedBlackNode left;
        RedBlackNode right;
        int color;

        RedBlackNode(Comparable comparable) {
            this(comparable, null, null);
        }

        RedBlackNode(Comparable comparable, RedBlackNode redBlackNode, RedBlackNode redBlackNode2) {
            this.element = comparable;
            this.left = redBlackNode;
            this.right = redBlackNode2;
            this.color = 1;
        }
    }
}

