/*
 * Decompiled with CFR 0.152.
 */
package weiss.nonstandard;

import weiss.nonstandard.BinaryNode;
import weiss.nonstandard.DuplicateItemException;
import weiss.nonstandard.ItemNotFoundException;
import weiss.nonstandard.Rotations;

public class SplayTree {
    private static BinaryNode newNode = null;
    private static BinaryNode header = new BinaryNode(null);
    private BinaryNode root = nullNode;
    private static BinaryNode nullNode;

    public void insert(Comparable comparable) {
        if (newNode == null) {
            newNode = new BinaryNode(null);
        }
        SplayTree.newNode.element = comparable;
        if (this.root == nullNode) {
            SplayTree.newNode.left = SplayTree.newNode.right = nullNode;
            this.root = newNode;
        } else {
            this.root = this.splay(comparable, this.root);
            if (comparable.compareTo(this.root.element) < 0) {
                SplayTree.newNode.left = this.root.left;
                SplayTree.newNode.right = this.root;
                this.root.left = nullNode;
                this.root = newNode;
            } else if (comparable.compareTo(this.root.element) > 0) {
                SplayTree.newNode.right = this.root.right;
                SplayTree.newNode.left = this.root;
                this.root.right = nullNode;
                this.root = newNode;
            } else {
                throw new DuplicateItemException(comparable.toString());
            }
        }
        newNode = null;
    }

    public void remove(Comparable comparable) {
        BinaryNode binaryNode;
        this.root = this.splay(comparable, this.root);
        if (this.root.element.compareTo(comparable) != 0) {
            throw new ItemNotFoundException(comparable.toString());
        }
        if (this.root.left == nullNode) {
            binaryNode = this.root.right;
        } else {
            binaryNode = this.root.left;
            binaryNode = this.splay(comparable, binaryNode);
            binaryNode.right = this.root.right;
        }
        this.root = binaryNode;
    }

    public Comparable findMin() {
        if (this.isEmpty()) {
            return null;
        }
        BinaryNode binaryNode = this.root;
        while (binaryNode.left != nullNode) {
            binaryNode = binaryNode.left;
        }
        this.root = this.splay(binaryNode.element, this.root);
        return binaryNode.element;
    }

    public Comparable findMax() {
        if (this.isEmpty()) {
            return null;
        }
        BinaryNode binaryNode = this.root;
        while (binaryNode.right != nullNode) {
            binaryNode = binaryNode.right;
        }
        this.root = this.splay(binaryNode.element, this.root);
        return binaryNode.element;
    }

    public Comparable find(Comparable comparable) {
        this.root = this.splay(comparable, this.root);
        if (this.isEmpty() || this.root.element.compareTo(comparable) != 0) {
            return null;
        }
        return this.root.element;
    }

    public void makeEmpty() {
        this.root = nullNode;
    }

    public boolean isEmpty() {
        return this.root == nullNode;
    }

    private BinaryNode splay(Comparable comparable, BinaryNode binaryNode) {
        BinaryNode binaryNode2;
        SplayTree.header.left = SplayTree.header.right = nullNode;
        BinaryNode binaryNode3 = binaryNode2 = header;
        SplayTree.nullNode.element = comparable;
        while (true) {
            if (comparable.compareTo(binaryNode.element) < 0) {
                if (comparable.compareTo(binaryNode.left.element) < 0) {
                    binaryNode = Rotations.rotateWithLeftChild(binaryNode);
                }
                if (binaryNode.left == nullNode) break;
                binaryNode2.left = binaryNode;
                binaryNode2 = binaryNode;
                binaryNode = binaryNode.left;
                continue;
            }
            if (comparable.compareTo(binaryNode.element) <= 0) break;
            if (comparable.compareTo(binaryNode.right.element) > 0) {
                binaryNode = Rotations.rotateWithRightChild(binaryNode);
            }
            if (binaryNode.right == nullNode) break;
            binaryNode3.right = binaryNode;
            binaryNode3 = binaryNode;
            binaryNode = binaryNode.right;
        }
        binaryNode3.right = binaryNode.left;
        binaryNode2.left = binaryNode.right;
        binaryNode.left = SplayTree.header.right;
        binaryNode.right = SplayTree.header.left;
        return binaryNode;
    }

    public static void main(String[] stringArray) {
        SplayTree splayTree = new SplayTree();
        System.out.println("Checking... (no bad output means success)");
        int n = 307;
        while (n != 0) {
            splayTree.insert(new Integer(n));
            n = (n + 307) % 40000;
        }
        System.out.println("Inserts complete");
        int n2 = 1;
        while (n2 < 40000) {
            splayTree.remove(new Integer(n2));
            n2 += 2;
        }
        System.out.println("Removes complete");
        if ((Integer)splayTree.findMin() != 2 || (Integer)splayTree.findMax() != 39998) {
            System.out.println("FindMin or FindMax error!");
        }
        int n3 = 2;
        while (n3 < 40000) {
            if ((Integer)splayTree.find(new Integer(n3)) != n3) {
                System.out.println("Error: find fails for " + n3);
            }
            n3 += 2;
        }
        int n4 = 1;
        while (n4 < 40000) {
            if (splayTree.find(new Integer(n4)) != null) {
                System.out.println("Error: Found deleted item " + n4);
            }
            n4 += 2;
        }
    }

    static {
        SplayTree.nullNode.left = SplayTree.nullNode.right = (nullNode = new BinaryNode(null));
    }
}

