import java.util.Comparator;

class CompareTestInner2
{
    public static Object findMax( Object [ ] a, Comparator cmp )
    {
        int maxIndex = 0;
        for( int i = 1; i < a.length; i++ )
            if( cmp.compare( a[ i ], a[ maxIndex ] ) > 0 )
                maxIndex = i;
        
        return a[ maxIndex ];
    }
    

    public static void main( String [ ] args )
    {
        Object [ ] rects = new Object[ 4 ];
        rects[ 0 ] = new SimpleRectangle( 1, 10 );
        rects[ 1 ] = new SimpleRectangle( 20, 1 );
        rects[ 2 ] = new SimpleRectangle( 4, 6 );
        rects[ 3 ] = new SimpleRectangle( 5, 5 );

    
        class OrderRectByWidth implements Comparator
        {
            public int compare( Object obj1, Object obj2 )
            {
                SimpleRectangle r1 = (SimpleRectangle) obj1;
                SimpleRectangle r2 = (SimpleRectangle) obj2;
            
                return( r1.getWidth() - r2.getWidth() );
            }
        }

        class OrderRectByArea implements Comparator
        {
            public int compare( Object obj1, Object obj2 )
            {
                SimpleRectangle r1 = (SimpleRectangle) obj1;
                SimpleRectangle r2 = (SimpleRectangle) obj2;
    
                return( r1.getWidth()*r1.getLength() -
                        r2.getWidth()*r2.getLength() );
            }
        }

    
        System.out.println( "MAX WIDTH: " + findMax( rects, new OrderRectByWidth( ) ) );
        System.out.println( "MAX AREA: " + findMax( rects, new OrderRectByArea( ) ) );
    }
}
