package klocke.ws0203.mci2.online.database;

/** Festlegung von Datenbank-Konstanten
 * f&uuml;r die Datenbankinstanz HETY (Hebraeische Typographie)
 */  
public interface DBConstants
{ 
   
    
   public static final String DB = "klocke.ws0203.mci2.online.bundles.db";
   /** JDBC Driver. 
    * for example: <b>org.gjt.mm.mysql.Driver</b>
    */
   
   //   public static final String JDBC_DRIVER = java.util.ResourceBundle.getBundle(DB).getString("JdbcDriver");
   public static final String JDBC_DRIVER = java.util.ResourceBundle.getBundle(DB).getString("JdbcDriver");
  
   /** JDBC-Driver-URL-Prefix.  
    * for example: <b>jdbc:mysql:</b>
   */
   public static final String JDBC_URL_PREFIX = java.util.ResourceBundle.getBundle(DB).getString("UrlPrefix");

   
   // datenbankspezifische Konstanten 
   
   /** IP-Adresse des Datenbankservers.
    * Konstanter Wert: <b>139.6.61.115</b>
    */
   static final String DBSERVERIPNR = java.util.ResourceBundle.getBundle(DB).getString("DBServerIpNr");
   static final String DBSERVERNAME = java.util.ResourceBundle.getBundle(DB).getString("DBServerName");
  
   
   /** Port-Nummer des Servers. 
    *  Konstanter Wert: <b>1521</b> bzw. <b>3306</b> 
    */
   static final String PORT = java.util.ResourceBundle.getBundle(DB).getString("Port");
   
   static final String DATABASE = java.util.ResourceBundle.getBundle(DB).getString("Database");      

   static final String DBUSER = java.util.ResourceBundle.getBundle(DB).getString("DepotUser");
   static final String DBPASSWORD = java.util.ResourceBundle.getBundle(DB).getString("DepotPassword");         
  
} 
