/*
 * DBVerbindung.java
 *
 * Created on 21. November 2002
 * by Heiner Klocke
 *
 * Alle Konstanten, die sich auf die Datenbank beziehen sind in db.propersies eingetragen.
 * Der Zugriff auf diese Datei erfolgt in dem Interface DBConstants
 */
 
package klocke.ws0203.mci2.online.database;

import java.sql.*; 

/** Diese Klasse sorgt fr die Verbindung mit der Datenbank. 
 * Die Datenbank-Verbindung ist eine Klassenvariable und wird zunchst mit <i>null</i>
 * inizialisiert. Die ffentliche Klassenmethode verbindung() liefert die Verbindung 
 * zurck. Wenn keine Verbindung besteht, oder diese bereits geschlossen wurde, so
 * erstellt verbindung() eine neue Datenbank-Verbindung.
 */
public class DBVerbindung extends Object implements DBConstants{
   
   private static final boolean DEBUG = false;
   private static Connection con = null;
   
   /** Erzeugt, falls sie noch nicht existiert oder geschlossen wurde
    * eine neue Verbindung con mit einer Datenbank 
    * @throws SQLException Falls Verbindung scheitert.
    * @return Der Wert der statischen variable con
    */
   public static Connection verbindung() throws SQLException {
      if (DEBUG)  System.out.println("Connection.verbindung()");
      return con;
   }


   /** Diese Methode liefert eine Verbindung zur Datenbank HETY zur&uuml;ck,
    * wenn Pa&szlig;wort und Benutzername von der Datenbank akzeptiert werden.
    * @param user Die Benutzerkennung
    * @param password Das Pa&szlig;wort
    * @throws SQLException Wenn ein SQL Fehler auftritt. Zum Beispiel bei Eingabe
    * eines falschen Pa&szlig;wortes.
    * @return Die Verbindung mit der Datenbank HETY, oder null.
    */
   public static Connection login(String user, String password)throws SQLException {
      if (DEBUG)  System.out.println("Connection.login("+user+','+password+")");
      
      String prefix = JDBC_URL_PREFIX,
      serverName = DBSERVERNAME,
      serverIpNr = DBSERVERIPNR,
      port = PORT,
      dbName = DATABASE,
      dbUser = DBUSER,
      dbPassword = DBPASSWORD;
      
        
      boolean treiberOK = testeTreiber(JDBC_DRIVER);
      if (treiberOK) {
         String url = prefix + serverIpNr + ":" + port + dbName;
         con = DriverManager.getConnection(url, user, password);
         System.out.println("db open from DBVerbindung.login(user, password) via " + url);                              


      } else return null;
      
      return con;
   }
   
   public static Connection login ( String servletname) throws SQLException {
      String prefix = JDBC_URL_PREFIX,
      serverName = DBSERVERNAME,
      serverIpNr = DBSERVERIPNR,
      port = PORT,
      dbName = DATABASE,
      dbUser = DBUSER,
      dbPassword = DBPASSWORD;

      
      boolean treiberOK = testeTreiber(JDBC_DRIVER);
      if (treiberOK) {
         String url = prefix + serverIpNr + ":" + port + dbName;
         con = DriverManager.getConnection(url, dbUser, dbPassword);
         //         Connection verbindung = DriverManager.getConnection(url);         
      } else return null;

      return con;
   }
   
   public static Connection logout( String servletname){
      try{
         if (con != null) {
             con.close();
             System.out.println("db closed from DBVerbindung.logout(" + servletname + ")");
         }
      } catch(SQLException exc){
          con = null;
          System.err.println(exc.toString());
      }
      return con;
   }

   /** Prft of der Treiber gefunden werden kann.
    * @return Wahr, wenn der Treiber geladen wird.
    */
   private static boolean testeTreiber(String treiber){
      if (DEBUG)  System.out.println("Connection.testeTreiber("+treiber+')');
    try { 
        Class.forName(String.valueOf(treiber)).newInstance();
    }
    catch (Exception exc) {
        System.err.println(exc.toString()); 
    }
    return true;
   }

    /** DBVerbindung soll nicht instantiert werden */
    protected DBVerbindung() {
    }

   /** Liefert die Verbindung con zur&uuml;ck.
    * @return Der Wert der Eigenschaft con.
    */
   public static Connection getCon() {
      if (DEBUG)  System.out.println("Connection.getCon()");
      return con;
   }
      
}
