/*
 * DozentenSessionDispatcher.java
 *
 * Created on 13. Dezember 2002, 17:33
 */


package klocke.ws0203.mci2.online.lib;

import java.io.*;
import java.net.*;

import javax.servlet.*;
import javax.servlet.http.*;


// JAXP packages
import javax.xml.parsers.*; 
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.w3c.dom.*;

import java.sql.*;

import klocke.ws0203.mci2.online.xmluserinterface.*;
import klocke.ws0203.mci2.online.database.DBVerbindung; 

/**
 *
 * @author  Heiner Klocke
 * Modified: 03. Januar 2003
 */
public class DozentenSessionDispatcher {

  private Connection verbindung = null;
  private DocumentBuilderFactory dbf;
  private DocumentBuilder dbl;
  
  
    // p u b l i c
    public static String SessionDispatcherName="SessionDispatcherName";

    public final static String MODUS_01 ="FunctionsDozenten";
    public final static String MODUS_02 ="ShowDozenten";        
    public final static String MODUS_03 ="NewDozent";        
    public final static String MODUS_04 ="EditDozent";            
    public final static String MODUS_05 ="DeleteDozent";
    public final static String MODUS_06 ="FindDozenten";    
    public String Ip;
        
        
    // p r i v a t e
    private int ComeInCount;
    private String Modus;
     
    public Dozenten dozenten;
    public Dozent dozent;
        
    private StringBuffer buf = new StringBuffer();        
    
    /** Creates a new instance of SessionDispatcher */
    public DozentenSessionDispatcher(String Ip){

        this.ComeInCount = 0;
        this.Modus= MODUS_01;
        this.Ip= Ip;
  
        try{
            if (verbindung == null) {
                verbindung = DBVerbindung.login( "DozentenSessionDispatcher" );
                dozenten = new Dozenten(verbindung);
                dozent = new Dozent(verbindung);

            }
            
        }
        catch(SQLException exc){
            verbindung = null;
            System.err.println(exc.toString());
        }        
        
//        dbl = createDocumentBuilder();
    }
    
    public boolean trackSession(
        HttpServletRequest request, 
        HttpServletResponse response) 
        throws ServletException, IOException{
        
        
        //setup
        ComeInCount++;
        
        //Log
        System.out.println("--> DozentenSessionDispatcher.getSession | Ip: "+ this.Ip+ "\t | Hit: "+ this.ComeInCount+ "\t | Modus: "+ this.Modus);

        String httpMode = "";
        PrintWriter responseOutput;
        response.setContentType("text/html");
        responseOutput = response.getWriter();
        buf.setLength(0);
             

        System.out.println("Modus = " + Modus + "*****");    
             
        //Dozenten ----------------------------------------------------------------
        if (Modus.equals(this.MODUS_01)){

            httpMode = request.getParameter("dozenten");    
            if (httpMode == null) return true;
            
            System.out.println("httpMode = " + httpMode + "*****");          
            
            if (httpMode.equals("functions")) {
                dozenten.functionsDozenten(request, responseOutput);
            }
            else {
       
                if (httpMode.equals("show")){
                    this.Modus = this.MODUS_02;  
                }
                if (httpMode.equals("new")){
                    this.Modus = this.MODUS_03;  
                }
                if (httpMode.equals("loeschen")){
                    this.Modus = this.MODUS_05;  
                }                
                if (httpMode.equals("loeschen-?")){
                    this.Modus = this.MODUS_05;  
                }
                if (httpMode.equals("find")){
                    this.Modus = this.MODUS_06;  
                }
                
            }
            
        }
        
        //ShowDozenten ----------------------------------------------------------------
        if(Modus.equals(this.MODUS_02)){

            dozenten.selectRows(request, responseOutput);
            
            System.out.println("Show Dozenten");                
            this.Modus = this.MODUS_01;            
            
            return true;
        }
            
         //NewDozent - Eingabemaske erzeugen erzeugen und Eingabe sichern -------------------------
        if (Modus.equals(this.MODUS_03)){

            httpMode = request.getParameter("dozenten");    
            System.out.println("httpMode = " + httpMode + "*****");          

            if ( httpMode != null && httpMode.equals("functions")) {
                dozenten.functionsDozenten(request, responseOutput);
                this.Modus = this.MODUS_01;
                return true;
            }                  
            
            if ( request.getParameter("dozenten").equals("Eingabe sichern")) {
                 dozent.insertTupel(request, responseOutput);
                 System.out.println("Dozent sichern");                
                 this.Modus = this.MODUS_03;
                 return true;
            }
            else {
                dozent.inputMaskDozent(request, responseOutput);
                System.out.println("neuen Dozent eingeben");
            }
            
            return true;
                       
        }

        //ShowDozenten ----------------------------------------------------------------
        if(Modus.equals(this.MODUS_05)){

            httpMode = request.getParameter("dozenten");    
            if (httpMode != null) System.out.println("httpMode = " + httpMode + "*****");          

           
            if ( httpMode != null && httpMode.equals("functions")) {
                dozenten.functionsDozenten(request, responseOutput);
                this.Modus = this.MODUS_01;
                return true;
            }                  

            if ( httpMode != null && httpMode.equals("loeschen")) {

                dozent.deleteConfirm(request, responseOutput);
                System.out.println("Dozent wirklich loeschen?");
                return true;
            }
            
            httpMode = request.getParameter("antwort");
            if (httpMode != null) System.out.println("Antwort = " + httpMode);
            if (httpMode != null && httpMode.equals("ja") ) {
                
                if (dozent.deleteDozent(request, responseOutput) == false)
                    dozenten.functionsDozenten(request, responseOutput);
                System.out.println("Dozent geloescht");

//                this.Modus = this.MODUS_01;
                return true;
            }
            
            return true;
        }
                    
        

        //FindDozent Suchmaske darstellen ---------------------------------
        if (Modus.equals(this.MODUS_06)){

            if ( request.getParameter("dozenten").equals("functions")) {
                 dozenten.functionsDozenten(request, responseOutput);
                 System.out.println("gefundene Dozenten ausgeben");                
                 this.Modus = this.MODUS_01;
                 return true;
            }
            
            if ( request.getParameter("dozenten").equals("suchen")) {
                 dozenten.findRows(request, responseOutput);
                 System.out.println("gefundene Dozenten ausgeben");                
                 this.Modus = this.MODUS_01;
            }
            else {
                dozent.findMaskDozent(request, responseOutput);
                System.out.println("Dozenten suchen");
            }
            
            return true;
                       
        }
        
        
        return false;
        
    }// trackSession
    
    
    
// -----------------------------------------------------------------------------
  private DocumentBuilder createDocumentBuilder() {
 
      boolean dtdValidate = false;
      boolean xsdValidate = false;

      boolean ignoreWhitespace = false;
      boolean ignoreComments = false;
      boolean putCDATAIntoText = false;
      boolean createEntityRefs = false;

      dbf = DocumentBuilderFactory.newInstance();
      // Set namespaceAware to true to get a DOM Level 2 tree with nodes
      // containing namesapce information.  This is necessary because the
      // default value from JAXP 1.0 was defined to be false.
      dbf.setNamespaceAware(false);

      // Set the validation mode to either: no validation, DTD
      // validation, or XSD validation
      dbf.setValidating(dtdValidate || xsdValidate);

      // Optional: set various configuration options
      dbf.setIgnoringComments(ignoreComments);
      dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
      dbf.setCoalescing(putCDATAIntoText);
      // The opposite of creating entity ref nodes is expanding them inline
      dbf.setExpandEntityReferences(!createEntityRefs);
      
      try {
          dbl = dbf.newDocumentBuilder();
//          OutputStreamWriter errorWriter = new OutputStreamWriter(System.err, outputEncoding);
//          db.setErrorHandler(new MyErrorHandler(new PrintWriter(errorWriter, true)));
      } catch (Exception e) {
          e.printStackTrace();
      }          
      return dbl;
  }    
          
}//class DozentenSessionDispatcher
    

