package klocke.ws0203.mci2.online.servlets;

// Eingabe von MCI2002-Teilnehmer
// Date: 24.01.2002
// written by: Heiner Klocke


// Die Servletklassen 
import java.net.URL;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

// Die HTML User Interface Klassen
import klocke.ws0203.mci2.online.xmluserinterface.*;
import klocke.ws0203.mci2.online.database.DBVerbindung;

public class DozentInsertServlet extends HttpServlet
{ 
  private static Connection verbindung = null;
  private static Dozent dozent;
  
  
  public void init(ServletConfig config) throws ServletException
  {
    super.init(config);
    
    try{
        if (verbindung == null) {
            verbindung = DBVerbindung.login( "DozentInsertServlet" );
            dozent = new Dozent(verbindung);
        }
    }
    catch(SQLException exc){
        verbindung = null;
        System.err.println(exc.toString());
    }    
  }
  
  public void destroy()
  { 
        if (verbindung != null) {
            DBVerbindung.logout( "DozentInsertServlet" );
            verbindung = null;
        }
  }


  protected void processRequest (HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException
  {
//    dozent = new Dozent();
    response.setContentType("text/html");
    PrintWriter responseOutput = response.getWriter();
    dozent.insertTupel(request, responseOutput );
  }
  
  
  public void doGet (HttpServletRequest request, HttpServletResponse response) 
                    throws ServletException, IOException
  {
      processRequest(request, response);
  }
      
   public void doPost (HttpServletRequest request, HttpServletResponse response) 
                    throws ServletException, IOException
  {
      processRequest(request, response);        
  } 

}
