package klocke.ws0203.mci2.online.servlets;

/* Servlet: Mci2DozentenServlet
 * written by: Heiner Klocke
 * Date: 21.11.2002
 * Modified on: 05. Januar 2003
 */

// Die Servletklassen 

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*; 


// Session-Dispatcher
import klocke.ws0203.mci2.online.lib.*;
  
public class Mci2DozentenServlet extends HttpServlet
{ 
  private StringBuffer buf = new StringBuffer();
  private DozentenSessionDispatcher SDp;
  private boolean DZSes = false;
 

// -----------------------------------------------------------------------------
  public void init(ServletConfig config) throws ServletException
  {
    super.init(config);
  }

// -----------------------------------------------------------------------------
  public void destroy(){ 
 }
 
  
// -----------------------------------------------------------------------------
  protected void processRequest
    (HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException
  {
    
    buf.setLength(0);
    response.setContentType("text/html");
    PrintWriter responseOutput = response.getWriter();
    
    SDp= (DozentenSessionDispatcher)request.getSession().getAttribute(DozentenSessionDispatcher.SessionDispatcherName);

    if(SDp == null){
        //login
        SDp = new DozentenSessionDispatcher(request.getSession().getId());
        request.getSession().setAttribute(DozentenSessionDispatcher.SessionDispatcherName, SDp);
        System.out.println("--> processRequest : create "+ SDp.Ip);

    }
    if( SDp.trackSession(request, response)){
        // hold Session
        System.out.println("--> processRequest : processed ... hold "+ SDp.Ip);
    }
    else{
        //logout
        System.out.println("--> processRequest : delete "+ SDp.Ip);
        request.getSession().setAttribute(DozentenSessionDispatcher.SessionDispatcherName, null);
        SDp = null;
        return;
    }  
      
    // HTML-Seite in "buf" zum Client senden   
    responseOutput.println(buf.toString());
    responseOutput.close();
  }  
  
// -----------------------------------------------------------------------------
  public void doGet
        (HttpServletRequest request, HttpServletResponse response) 
         throws ServletException, IOException
  {
    processRequest( request, response );
  }
  
// -----------------------------------------------------------------------------
   public void doPost
        (HttpServletRequest request, HttpServletResponse response) 
        throws ServletException, IOException
  {
    processRequest( request, response );
  } 
   
   private void doDozentenSession(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException
   {

    SDp= (DozentenSessionDispatcher)request.getSession().getAttribute(DozentenSessionDispatcher.SessionDispatcherName);

    if(SDp == null){
        //login
        SDp = new DozentenSessionDispatcher(request.getSession().getId());
        request.getSession().setAttribute(DozentenSessionDispatcher.SessionDispatcherName, SDp);
        System.out.println("--> processRequest : create "+ SDp.Ip);

    }
    if( SDp.trackSession(request, response)){
        // hold Session
        System.out.println("--> processRequest : processed ... hold "+ SDp.Ip);
    }
    else{
        //logout
        System.out.println("--> processRequest : delete "+ SDp.Ip);
        request.getSession().setAttribute(DozentenSessionDispatcher.SessionDispatcherName, null);
        SDp = null;
        return;
    }       
   }

}
