package klocke.ws0203.mci2.online.servlets;

/* Servlet: ShowServlet
 * written by: Heiner Klocke
 * Date: 21.11.2002
 * Modified on: 21. November 2002
 */

// JAXP packages
import javax.xml.parsers.*; 
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.w3c.dom.*;

// Die Servletklassen 
import java.net.URL;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*; 
import java.sql.*;
import java.util.*;

// Die XML User Interface Klassen
import klocke.ws0203.mci2.online.xmluserinterface.*;
import klocke.ws0203.mci2.online.database.DBVerbindung; 

// SessionDispatcher
import klocke.ws0203.mci2.online.lib.*;
  
public class ShowServlet extends HttpServlet
{ 
  private static Connection verbindung = null;
  private StringBuffer buf = new StringBuffer();

  private static Dozenten dozenten;
  private static Kurse kurse;

  private static DocumentBuilderFactory dbf;
  private static DocumentBuilder dbl;
  
  private SessionDispatcher SDp;
  

// -----------------------------------------------------------------------------
  public void init(ServletConfig config) throws ServletException
  {
    
    super.init(config);

    try{
        if (verbindung == null) {
            verbindung = DBVerbindung.login( "ShowServlet" );
            dozenten = new Dozenten(verbindung);
            kurse = new Kurse(verbindung);
        }
            
    }
    catch(SQLException exc){
        verbindung = null;
        System.err.println(exc.toString());
    }
    
    dbl = this.createDocumentBuilder();
  }

// -----------------------------------------------------------------------------
  public void destroy(){ 
    if (verbindung != null) {
        DBVerbindung.logout("ShowServlet");
        verbindung = null;}}
  
  
// -----------------------------------------------------------------------------
  protected void processRequest
        (HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException
  {

    String tabelle =  String.valueOf(request.getParameter("tabelle")).toString();
    
    buf.setLength(0);
    response.setContentType("text/html");
    PrintWriter responseOutput = response.getWriter();
   
    System.out.println(tabelle);      
      
      
        SDp= (SessionDispatcher)request.getSession().getAttribute(SessionDispatcher.SessionDispatcherName);

        if(SDp == null){
            //login
            SDp = new SessionDispatcher(request.getSession().getId());
            request.getSession().setAttribute(SessionDispatcher.SessionDispatcherName, SDp);
            System.out.println("--> processRequest : create "+ SDp.Ip);

        }
        if( SDp.trackSession(request, response)){
            // holde Session
            System.out.println("--> processRequest : processed ... hold "+ SDp.Ip);
        }
        else{
            //logout
            System.out.println("--> processRequest : delete "+ SDp.Ip);
            request.getSession().setAttribute(SessionDispatcher.SessionDispatcherName, null);
            SDp = null;
            return;
        }      
      
     
      
/*    
    if ( tabelle.equals("dozenten") )
        dozenten.selectRows(request, responseOutput, dbl);

    if ( tabelle.equals("kurse") )
        kurse.selectRows(request, responseOutput, dbl);
*/
        
    responseOutput.println(buf.toString());
    responseOutput.close();
  }  
  
// -----------------------------------------------------------------------------
  public void doGet
        (HttpServletRequest request, HttpServletResponse response) 
         throws ServletException, IOException
  {
    processRequest( request, response );
  }
  
// -----------------------------------------------------------------------------
   public void doPost
        (HttpServletRequest request, HttpServletResponse response) 
        throws ServletException, IOException
  {
    processRequest( request, response );
  } 

// -----------------------------------------------------------------------------
  private DocumentBuilder createDocumentBuilder() {
 
      boolean dtdValidate = false;
      boolean xsdValidate = false;

      boolean ignoreWhitespace = false;
      boolean ignoreComments = false;
      boolean putCDATAIntoText = false;
      boolean createEntityRefs = false;

      dbf = DocumentBuilderFactory.newInstance();
      // Set namespaceAware to true to get a DOM Level 2 tree with nodes
      // containing namesapce information.  This is necessary because the
      // default value from JAXP 1.0 was defined to be false.
      dbf.setNamespaceAware(false);

      // Set the validation mode to either: no validation, DTD
      // validation, or XSD validation
      dbf.setValidating(dtdValidate || xsdValidate);

      // Optional: set various configuration options
      dbf.setIgnoringComments(ignoreComments);
      dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
      dbf.setCoalescing(putCDATAIntoText);
      // The opposite of creating entity ref nodes is expanding them inline
      dbf.setExpandEntityReferences(!createEntityRefs);
      
      try {
          dbl = dbf.newDocumentBuilder();
//          OutputStreamWriter errorWriter = new OutputStreamWriter(System.err, outputEncoding);
//          db.setErrorHandler(new MyErrorHandler(new PrintWriter(errorWriter, true)));
      } catch (Exception e) {
          e.printStackTrace();
      }          
      return dbl;
  }

// -----------------------------------------------------------------------------
}
