package klocke.ws0203.mci2.online.servlets;

/* Servlet: StudentenServlet
 * written by: Marcus Wolf, 
 * Date: 5.12.2002
 */

// JAXP packages
import javax.xml.parsers.*; 
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.w3c.dom.*;

// Die Servletklassen 
import java.net.URL;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*; 
import java.sql.*;
import java.util.*;

// Die HTML User Interface Klassen
import klocke.ws0203.mci2.online.xmluserinterface.*;
import klocke.ws0203.mci2.online.database.DBVerbindung; 

  
public class StudentenServlet extends HttpServlet
{ 
  
  private Studenten student;
  private String modus;
  
  private static Connection verbindung = null;
  
  private static DocumentBuilderFactory dbf;
  private static DocumentBuilder dbl;

  private StringBuffer buf = new StringBuffer();

 // -----------------------------------------------------------------------------
  public void init(ServletConfig config) 
  throws ServletException
  {
    super.init(config);

    try{ 
        if (verbindung == null) {
            verbindung = DBVerbindung.login( "StudentenServlet" );}}
    catch(SQLException exc){
        verbindung = null;
        System.err.println(exc.toString());}
    
    dbl = createDocumentBuilder();
//    student = new Studenten(verbindung);

  }

// -----------------------------------------------------------------------------
  public void destroy(){ 
    if (verbindung != null) {
        DBVerbindung.logout("StudentenServlet");
        verbindung = null;}}
  
  
// -----------------------------------------------------------------------------
  protected void processRequest
        (HttpServletRequest request, HttpServletResponse response)
        throws ServletException, IOException
  {
    student = new Studenten(verbindung);


    // Doc init
    response.setContentType("text/html");
    PrintWriter responseOutput = response.getWriter();
    
    // HTTP-Parameter modus lesen:
    modus=  String.valueOf(request.getParameter("modus")).toString();
    System.out.println("\n-->StudentenServlet modus: " + modus);
    
    if ( modus.equals("Identifizieren")){
        student.Modus= "Login";
        student.Identifizieren(request, responseOutput, dbl);
    }
    
    if ( modus.equals("Login")){
            // HTTP-Parameter in class Studenten schreiben:
            student.matrnr= String.valueOf(request.getParameter("matrnr")).toString();
            student.gebdatDD= Integer.parseInt(String.valueOf(request.getParameter("dd")).toString()); //?
            student.gebdatMM= Integer.parseInt(String.valueOf(request.getParameter("mm")).toString()); //?
            student.gebdatYYYY= Integer.parseInt(String.valueOf(request.getParameter("yyyy")).toString()); //?
            
            if(student.SqlIdentifikationTeste() == true){
                // Student ist identifiziert
            }
            else{
                // Student muss sich registrieren oder daten sind falsch eingegeben
                student.Modus= "Registrieren / Login";
                student.Identifizieren(request, responseOutput, dbl);
            }
    }

    if ( modus.equals("Registrieren / Login")){
            // HTTP-Parameter in class Studenten schreiben:
            student.matrnr= String.valueOf(request.getParameter("matrnr")).toString();
            student.gebdatDD= Integer.parseInt(String.valueOf(request.getParameter("dd")).toString()); //?
            student.gebdatMM= Integer.parseInt(String.valueOf(request.getParameter("mm")).toString()); //?
            student.gebdatYYYY= Integer.parseInt(String.valueOf(request.getParameter("yyyy")).toString()); //?

            if(student.SqlIdentifikationTeste() == true){
                // Student ist identifiziert
            }
            else{
                // Student muss sich registrieren oder daten sind falsch eingegeben
                student.Modus= "Registrieren";
                student.Registrieren(request, responseOutput, dbl);
            }
    }

    /*http://localhost:8080/mci2_online/servlet/klocke.ws0203.mci2.online.xmlservlets.StudentenServlet
    ?matrnr=11111111&
     dd=1&
     mm=1&
     yyyy=1900&
     name=Usan&
     vorname=Ali&
     email=mai@ali.de&
     studiengang=MI&
     dpo=3&
     modus=Registrieren
 
     */
    if ( modus.equals("Registrieren")){
            // HTTP-Parameter in class Studenten schreiben:
            student.matrnr= String.valueOf(request.getParameter("matrnr")).toString();
            student.gebdatDD= Integer.parseInt(String.valueOf(request.getParameter("dd")).toString()); //?
            student.gebdatMM= Integer.parseInt(String.valueOf(request.getParameter("mm")).toString()); //?
            student.gebdatYYYY= Integer.parseInt(String.valueOf(request.getParameter("yyyy")).toString()); //?
            student.name = String.valueOf(request.getParameter("name")).toString();
            student.vorname = String.valueOf(request.getParameter("vorname")).toString();
            student.email = String.valueOf(request.getParameter("email")).toString();
            student.studiengang = String.valueOf(request.getParameter("studiengang")).toString();
            student.dpo = String.valueOf(request.getParameter("dpo")).toString();
            student.SqlRegistrieren();
    }    
    // Doc is final
    buf.setLength(0);
    responseOutput.println(buf.toString());
    responseOutput.close();
  }  
  
// -----------------------------------------------------------------------------
  public void doGet
        (HttpServletRequest request, HttpServletResponse response) 
         throws ServletException, IOException
  {
    processRequest( request, response );
  }
  
// -----------------------------------------------------------------------------
   public void doPost
        (HttpServletRequest request, HttpServletResponse response) 
        throws ServletException, IOException
  {
    processRequest( request, response );
  } 

// -----------------------------------------------------------------------------
  private DocumentBuilder createDocumentBuilder() {
 
      boolean dtdValidate = false;
      boolean xsdValidate = false;

      boolean ignoreWhitespace = false;
      boolean ignoreComments = false;
      boolean putCDATAIntoText = false;
      boolean createEntityRefs = false;

      dbf = DocumentBuilderFactory.newInstance();
      // Set namespaceAware to true to get a DOM Level 2 tree with nodes
      // containing namesapce information.  This is necessary because the
      // default value from JAXP 1.0 was defined to be false.
      dbf.setNamespaceAware(false);

      // Set the validation mode to either: no validation, DTD
      // validation, or XSD validation
      dbf.setValidating(dtdValidate || xsdValidate);

      // Optional: set various configuration options
      dbf.setIgnoringComments(ignoreComments);
      dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
      dbf.setCoalescing(putCDATAIntoText);
      // The opposite of creating entity ref nodes is expanding them inline
      dbf.setExpandEntityReferences(!createEntityRefs);
      
      try {
          dbl = dbf.newDocumentBuilder();
//          OutputStreamWriter errorWriter = new OutputStreamWriter(System.err, outputEncoding);
//          db.setErrorHandler(new MyErrorHandler(new PrintWriter(errorWriter, true)));
      } catch (Exception e) {
          e.printStackTrace();
      }          
      return dbl;
  }

// -----------------------------------------------------------------------------
}
