package klocke.ws0203.mci2.online.xmluserinterface;

/*
 * Dozent.java
 * Written by: Heiner Klocke
 *
 * Created on 22. November 2002, 14:35
 * Modified on 05. Januar 2003
 *
 * Einfuegen eines DOZENTEN-Tupels
 * Suchmaske fuer Dozenten darstellen
 */


// JAXP packages
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.w3c.dom.*;

// (xerces.jar) 
import  org.w3c.dom.*;
import  org.apache.xerces.dom.DocumentImpl;
import  org.apache.xerces.dom.DOMImplementationImpl;
import  org.w3c.dom.Document;
import  org.apache.xml.serialize.OutputFormat; 
import  org.apache.xml.serialize.Serializer;
import  org.apache.xml.serialize.SerializerFactory;
import  org.apache.xml.serialize.XMLSerializer;

// (xalan.jar)
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult; 

import java.net.URL;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

import klocke.ws0203.mci2.online.constants.ServletConstants;

public class Dozent implements ServletConstants {
    private Connection verbindung;    
    private Statement stmt;
    
    private String dozenten_id,	vorname, name, kuerzel, url, email, passwdmd5, zeitstempel;    
   
    private static String webservername = WEBSERVERNAME,
                   webserverport = WEBSERVERPORT,
                   webservercontext = WEBSERVERCONTEXT;

    private Element dozenten, header, webserver, ueberschrift;
    
    
    /** Creates new Dozent */
    public Dozent() {
    }

    public Dozent( Connection verb ) {
        verbindung = verb;
    } 


    public void deleteConfirm ( HttpServletRequest request, PrintWriter responseOutput ) { 
        Document xmlDoc = new DocumentImpl();
        
        dozenten = xmlDoc.createElement("deleteConfirm");
        xmlDoc.appendChild(dozenten);

        Element webserver, item;
        webserver = xmlDoc.createElement("webserver");
        dozenten.appendChild(webserver);         
        
        item = xmlDoc.createElement("webservername");
        item.appendChild(xmlDoc.createTextNode(webservername));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webserverport");
        item.appendChild(xmlDoc.createTextNode(webserverport));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webservercontext");
        item.appendChild(xmlDoc.createTextNode(webservercontext));
        webserver.appendChild(item);         
        
        item = xmlDoc.createElement("dozenten_id");
        item.appendChild( xmlDoc.createTextNode(request.getParameter("dozenten_id")));            
        dozenten.appendChild(item);           
        
        Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "deleteDozentConfirm.xsl" );
//        Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "" );
    
    }      
    
    
    public boolean deleteDozent ( HttpServletRequest request, PrintWriter responseOutput ) { 
        Document xmlDoc = new DocumentImpl();
        
        if ( request.getParameter("dozenten_id").equals("") ) return false;
        
        try {
            stmt = verbindung.createStatement();        

            String query = "delete from dozenten where  dozenten_id = " + request.getParameter("dozenten_id");
            
            System.out.println(query); 
            
            stmt.executeUpdate(query);
            // Das commit macht der jdbc-driver
            
            stmt.close();
            
            dozenten = xmlDoc.createElement("deleted");
            xmlDoc.appendChild(dozenten);
            
            Element item;
            item = xmlDoc.createElement("dozenten_id");
            item.appendChild( xmlDoc.createTextNode(request.getParameter("dozenten_id")));            
            dozenten.appendChild(item);             
            
            
        } 
        catch (SQLException e) { 
            Element item;
            item = xmlDoc.createElement("SQLException");
            item.appendChild( xmlDoc.createTextNode(e.getMessage()));            
            dozenten.appendChild(item);  

            System.out.println("SQLException: " + e.getMessage() );
        }   
        
            Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "DozentDeleted.xsl" );
//        Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "" );
        return true;
    }    
    
    
    // DOM-Tree fuer Eingabemaske "neuen Dozent anlegen"
    public void inputMaskDozent ( HttpServletRequest request, PrintWriter responseOutput ) { 
       
        Element feld, webserver, item;
        
        Document xmlDoc = new DocumentImpl();
        
        dozenten = xmlDoc.createElement("dozenten");
        xmlDoc.appendChild(dozenten);  

        webserver = xmlDoc.createElement("webserver");
        dozenten.appendChild(webserver);         
        
        item = xmlDoc.createElement("webservername");
        item.appendChild(xmlDoc.createTextNode(webservername));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webserverport");
        item.appendChild(xmlDoc.createTextNode(webserverport));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webservercontext");
        item.appendChild(xmlDoc.createTextNode(webservercontext));
        webserver.appendChild(item);                 
        
        feld = xmlDoc.createElement("dozenten_id");
        feld.appendChild(xmlDoc.createTextNode("dozenten_id"));         
        dozenten.appendChild(feld);

        feld = xmlDoc.createElement("name");
        feld.appendChild(xmlDoc.createTextNode("name"));         
        dozenten.appendChild(feld);

        feld = xmlDoc.createElement("vorname");
        feld.appendChild(xmlDoc.createTextNode("vorname"));         
        dozenten.appendChild(feld);
        
        feld = xmlDoc.createElement("kuerzel");
        feld.appendChild(xmlDoc.createTextNode("kuerzel"));         
        dozenten.appendChild(feld);

        feld = xmlDoc.createElement("url");
        feld.appendChild(xmlDoc.createTextNode("url"));         
        dozenten.appendChild(feld);
        
        feld = xmlDoc.createElement("email");
        feld.appendChild(xmlDoc.createTextNode("email"));         
        dozenten.appendChild(feld);

        feld = xmlDoc.createElement("passwdmd5");
        feld.appendChild(xmlDoc.createTextNode("passwdmd5"));         
        dozenten.appendChild(feld);
        
        // HTML-Eingabemaske fuer neuen Dozent generieren
        Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "inputMaskDozent.xsl" );        
//      Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "" );        
        
    }    

    // DOM-Tree fuer Suchmaske "Dozenten suchen"
    public void findMaskDozent ( HttpServletRequest request, PrintWriter responseOutput ) { 
       
        Element feld, webserver, item;
        
        Document xmlDoc = new DocumentImpl();
        
        dozenten = xmlDoc.createElement("dozenten");
        xmlDoc.appendChild(dozenten);  

        webserver = xmlDoc.createElement("webserver");
        dozenten.appendChild(webserver);         
        
        item = xmlDoc.createElement("webservername");
        item.appendChild(xmlDoc.createTextNode(webservername));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webserverport");
        item.appendChild(xmlDoc.createTextNode(webserverport));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webservercontext");
        item.appendChild(xmlDoc.createTextNode(webservercontext));
        webserver.appendChild(item);           
                
        
        feld = xmlDoc.createElement("dozenten_id");
        feld.appendChild(xmlDoc.createTextNode("dozenten_id"));         
        dozenten.appendChild(feld);

        feld = xmlDoc.createElement("name");
        feld.appendChild(xmlDoc.createTextNode("name"));         
        dozenten.appendChild(feld);

        feld = xmlDoc.createElement("vorname");
        feld.appendChild(xmlDoc.createTextNode("vorname"));         
        dozenten.appendChild(feld);
        
        feld = xmlDoc.createElement("kuerzel");
        feld.appendChild(xmlDoc.createTextNode("kuerzel"));         
        dozenten.appendChild(feld);

        feld = xmlDoc.createElement("url");
        feld.appendChild(xmlDoc.createTextNode("url"));         
        dozenten.appendChild(feld);
        
        feld = xmlDoc.createElement("email");
        feld.appendChild(xmlDoc.createTextNode("email"));         
        dozenten.appendChild(feld);

        feld = xmlDoc.createElement("passwdmd5");
        feld.appendChild(xmlDoc.createTextNode("passwdmd5"));         
        dozenten.appendChild(feld);
        
        // HTML-Eingabemaske fuer neuen Dozent generieren
        Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "findMaskDozent.xsl" );        
//      Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "" );        
        
    }    
    
    
    public void insertTupel ( HttpServletRequest request, PrintWriter responseOutput ) { 
        Document xmlDoc = new DocumentImpl();
        
        dozenten = xmlDoc.createElement("insert");
        xmlDoc.appendChild(dozenten);  
        
        insertData( xmlDoc,  request );
            Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "newDozentInserted.xsl" );
//        Dozenten.transformDOMTreeToHTML( xmlDoc, responseOutput, "" );
    }

    
    public void insertData( Document xmlDoc, HttpServletRequest request ) {

       
        try {
            stmt = verbindung.createStatement();

            StringBuffer columns = new StringBuffer();
       
            // Namen der Spalten der Tabelle dozenten
            columns.append("dozenten_id, ");
            columns.append("name, ");
            columns.append("vorname, ");
            columns.append("kuerzel, ");
            columns.append("url, ");
            columns.append("email, ");
            columns.append("passwdmd5, ");
            columns.append("dozenten_zeitstempel");

            
            
            // Werte der Parameter setzen
            dozenten_id = request.getParameter("dozenten_id");
            vorname = request.getParameter("vorname");
            name = request.getParameter("name");
            kuerzel = request.getParameter("kuerzel");
            url = request.getParameter("url");            
            email = request.getParameter("email");
            passwdmd5 = request.getParameter("passwdmd5");
            
            // Datum und Zeit der Registrierung in der DB eintragen
            HttpSession session = request.getSession(true);
            java.sql.Date accessTime = new java.sql.Date(session.getLastAccessedTime());
            
            System.out.println(accessTime);
            String sqlDate = accessTime.toString();

            System.out.println(sqlDate);
            
            StringBuffer values = new StringBuffer();
            values.append("'" + dozenten_id + "', ");
            values.append("'" + name + "', ");
            values.append("'" + vorname + "', ");
            values.append("'" + kuerzel + "', ");
            values.append("'" + url + "', ");
            values.append("'" + email + "', ");
            values.append("'" + passwdmd5 + "', ");
            values.append("TO_Date('" + sqlDate + "', 'YYYY-MM-DD HH:MI:SS')");

            String query = "INSERT INTO dozenten (" + columns + ") VALUES (" + values + ")";
            
            System.out.println(query); 
            
            stmt.executeUpdate(query);
            // Das commit macht der jdbc-driver
            
            stmt.close();
            
            // DOM-Baum fuer Feedback erzeugen
            Element dozent, item;
            dozent = xmlDoc.createElement("dozent");
            dozenten.appendChild(dozent);


            webserver = xmlDoc.createElement("webserver");
            dozenten.appendChild(webserver);         
        
            item = xmlDoc.createElement("webservername");
            item.appendChild(xmlDoc.createTextNode(webservername));
            webserver.appendChild(item);
           
            item = xmlDoc.createElement("webserverport");
            item.appendChild(xmlDoc.createTextNode(webserverport));
            webserver.appendChild(item);
           
            item = xmlDoc.createElement("webservercontext");
            item.appendChild(xmlDoc.createTextNode(webservercontext));
            webserver.appendChild(item);             
            
            item = xmlDoc.createElement("dozenten_id");
            item.appendChild( xmlDoc.createTextNode(dozenten_id));
            dozent.appendChild(item);
            
            item = xmlDoc.createElement("name");
            item.appendChild( xmlDoc.createTextNode(name));
            dozent.appendChild(item);
            
            item = xmlDoc.createElement("vorname");
            item.appendChild( xmlDoc.createTextNode(vorname));
            dozent.appendChild(item);
            
            item = xmlDoc.createElement("kuerzel");
            item.appendChild( xmlDoc.createTextNode(kuerzel));
            dozent.appendChild(item);
            
            item = xmlDoc.createElement("url");
            item.appendChild( xmlDoc.createTextNode(url));
            dozent.appendChild(item);

            item = xmlDoc.createElement("email");
            item.appendChild( xmlDoc.createTextNode(email));
            dozent.appendChild(item);

            item = xmlDoc.createElement("passwdmd5");
            item.appendChild( xmlDoc.createTextNode(passwdmd5));
            dozent.appendChild(item);

            item = xmlDoc.createElement("dozenten_zeitstempel");
            item.appendChild( xmlDoc.createTextNode(sqlDate));
            dozent.appendChild(item);

            item = xmlDoc.createElement("SQLException");
            item.appendChild( xmlDoc.createTextNode(""));            
            dozenten.appendChild(item);              
            stmt.close();
            
        } 
        catch (SQLException e) { 
            Element item;
            
            webserver = xmlDoc.createElement("webserver");
            dozenten.appendChild(webserver);         
        
            item = xmlDoc.createElement("webservername");
            item.appendChild(xmlDoc.createTextNode(webservername));
            webserver.appendChild(item);
           
            item = xmlDoc.createElement("webserverport");
            item.appendChild(xmlDoc.createTextNode(webserverport));
            webserver.appendChild(item);
           
            item = xmlDoc.createElement("webservercontext");
            item.appendChild(xmlDoc.createTextNode(webservercontext));
            webserver.appendChild(item);                 
            
            item = xmlDoc.createElement("SQLException");
            item.appendChild( xmlDoc.createTextNode(e.getMessage()));            
            dozenten.appendChild(item);  

            System.out.println("SQLException: " + e.getMessage() );
        }
       }

   
}
