package klocke.ws0203.mci2.online.xmluserinterface;

/*
 * Dozenten.java
 * Written by: Heiner Klocke
 *
 * Created on 22. November 2002, 14:35
 * Modified on 05. Januar 2003

 */


// JAXP packages
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.w3c.dom.*;

// (xerces.jar) 
import  org.w3c.dom.*;
import  org.apache.xerces.dom.DocumentImpl;
import  org.apache.xerces.dom.DOMImplementationImpl;
import  org.w3c.dom.Document;
import  org.apache.xml.serialize.OutputFormat; 
import  org.apache.xml.serialize.Serializer;
import  org.apache.xml.serialize.SerializerFactory;
import  org.apache.xml.serialize.XMLSerializer;

// (xalan.jar)
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult; 

import java.net.URL;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

import klocke.ws0203.mci2.online.constants.ServletConstants;

public class Dozenten implements ServletConstants {
    private Connection verbindung;    
    private Statement stmt;
   
    private static String webservername = WEBSERVERNAME,
                   webserverport = WEBSERVERPORT,
                   webservercontext = WEBSERVERCONTEXT;

    private Element dozenten, header, webserver, ueberschrift;
    
    
    /** Creates new Dozenten */
    public Dozenten() {
    }

    public Dozenten( Connection verb ) {
        verbindung = verb;
    }
 

    public void functionsDozenten( HttpServletRequest request, PrintWriter responseOutput ) {
        
        Element function, item;
        
        Document xmlDoc = new DocumentImpl();

        
        
        dozenten = xmlDoc.createElement("dozenten");
        xmlDoc.appendChild(dozenten);  

        webserver = xmlDoc.createElement("webserver");
        dozenten.appendChild(webserver);         
        
        item = xmlDoc.createElement("webservername");
        item.appendChild(xmlDoc.createTextNode(webservername));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webserverport");
        item.appendChild(xmlDoc.createTextNode(webserverport));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webservercontext");
        item.appendChild(xmlDoc.createTextNode(webservercontext));
        webserver.appendChild(item);           
        
        
        
        function = xmlDoc.createElement("function");
        dozenten.appendChild(function);
        
        item = xmlDoc.createElement("show");
        item.appendChild(xmlDoc.createTextNode("show"));        
        function.appendChild(item);
        
        item = xmlDoc.createElement("new");
        item.appendChild(xmlDoc.createTextNode("new"));        
        function.appendChild(item);

        item = xmlDoc.createElement("edit");
        item.appendChild(xmlDoc.createTextNode("edit"));        
        function.appendChild(item);

        item = xmlDoc.createElement("find");
        item.appendChild(xmlDoc.createTextNode("find"));        
        function.appendChild(item);

        
        transformDOMTreeToHTML( xmlDoc, responseOutput, "functionsDozenten.xsl" );        
//      transformDOMTreeToHTML( xmlDoc, responseOutput, "" );        
        
    }

    public void findRows ( HttpServletRequest request, PrintWriter responseOutput ) {
        
        String dozenten_id,	vorname, name, kuerzel, url, email, passwdmd5, zeitstempel;
        Document xmlDoc = new DocumentImpl();

        StringBuffer columns = new StringBuffer();
       
            
        // Werte der Parameter setzen
        
        dozenten_id = request.getParameter("dozenten_id");
        vorname = request.getParameter("vorname");
        name = request.getParameter("name");
        kuerzel = request.getParameter("kuerzel");
        url = request.getParameter("url");            
        email = request.getParameter("email");
        passwdmd5 = request.getParameter("passwdmd5");        
        
        String qualifier = "";
        String column = "";

        if (!dozenten_id.equals("")) {
            column = "dozenten_id";
            qualifier = dozenten_id;
        }        
        if (!vorname.equals("")) {
            column = "vorname";
            qualifier = vorname;
        }
        if (!name.equals("")) {
            column = "name";
            qualifier = name;
        }
        if (!kuerzel.equals("")) {
            column = "kuerzel";
            qualifier = kuerzel;
        }
        if (!url.equals("")) {
            column = "url";
            qualifier = url;
        }        
        if (!email.equals("")) {
            column = "email";
            qualifier = email;
        }
        
        try {
            stmt = verbindung.createStatement();
            StringBuffer colBuf = new StringBuffer();
 
            String query;
                        
            query = "select * FROM DOZENTEN WHERE " + column + " like '" + qualifier + "'";
                
            System.out.println(query);
          
            ResultSet rs = stmt.executeQuery(query);            
            ResultSetMetaData rsmd = rs.getMetaData();

            buildDOMTree( rs, rsmd, xmlDoc);

           transformDOMTreeToHTML( xmlDoc, responseOutput, "showDozenten.xsl" );
//           transformDOMTreeToHTML( xmlDoc, responseOutput, "" );

            rs.close();
            stmt.close();
            }
        catch (SQLException e) {
            System.out.println("SQLException: " + e.getMessage() );
        }
    }
   
    
    public void selectRows ( HttpServletRequest request, PrintWriter responseOutput ) {

        Document xmlDoc = new DocumentImpl();
        
        try {
            stmt = verbindung.createStatement();
            StringBuffer colBuf = new StringBuffer();
 
            String query;
            query = "SELECT * FROM DOZENTEN";
                
            System.out.println(query);

            ResultSet rs = stmt.executeQuery(query);            
            ResultSetMetaData rsmd = rs.getMetaData();

            buildDOMTree( rs, rsmd, xmlDoc);

            transformDOMTreeToHTML( xmlDoc, responseOutput, "showDozenten.xsl" );
//            transformDOMTreeToHTML( xmlDoc, responseOutput, "" );
            rs.close();
            stmt.close();
            }
        catch (SQLException e) {
            System.out.println("SQLException: " + e.getMessage() );
        }
    }
    
    public void buildDOMNodesDozent( ResultSetMetaData rsmd, ResultSet rs, Document xmlDoc ) throws SQLException {
        boolean moreRecords = rs.next();
        
        Element dozent, item;
  
        if (! moreRecords ) {
            
            dozent = xmlDoc.createElement("notupel");
            dozent.appendChild( xmlDoc.createTextNode("leer"));            
            dozenten.appendChild(dozent);
            return;
        }
    
        try {
            // get row data
            do {
                dozent = xmlDoc.createElement("tupel");
                dozenten.appendChild(dozent);
                for ( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
                    item = xmlDoc.createElement(rsmd.getColumnName(i));
                    item.appendChild(xmlDoc.createTextNode( rs.getString(rsmd.getColumnName(i)) ));
                    dozent.appendChild(item);
                }
                item = xmlDoc.createElement("delTup");
                item.appendChild(xmlDoc.createTextNode(rs.getString("dozenten_id")));
                dozent.appendChild(item);
            } while (rs.next() );
          
        } catch ( SQLException sqlex ) {
            sqlex.printStackTrace();
        }
        
    }

    private void buildDOMTree( ResultSet rs, ResultSetMetaData rsmd, Document xmlDoc) {
        dozenten = xmlDoc.createElement("showdozenten");
        xmlDoc.appendChild(dozenten);  
        header = xmlDoc.createElement("header");
        dozenten.appendChild(header); 
        webserver = xmlDoc.createElement("webserver");
        dozenten.appendChild(webserver); 
        ueberschrift = xmlDoc.createElement("ueberschrift");
        dozenten.appendChild(ueberschrift);                     

        Element item;

        item = xmlDoc.createElement("webservername");
        item.appendChild(xmlDoc.createTextNode(webservername));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webserverport");
        item.appendChild(xmlDoc.createTextNode(webserverport));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webservercontext");
        item.appendChild(xmlDoc.createTextNode(webservercontext));
        webserver.appendChild(item);           

        // DB-Spaltennamen in den DOM-Tree einfuegen
        try {
            
            for ( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
                item = xmlDoc.createElement("c" + rsmd.getColumnName(i));
                item.appendChild(xmlDoc.createTextNode(rsmd.getColumnName(i)));
                System.out.println(rsmd.getColumnName(i));
                ueberschrift.appendChild(item);
            }        
        } catch ( SQLException sqlex ) {
            sqlex.printStackTrace();
        }

        try {
        
            // insert all rows into DOM-Tree
            buildDOMNodesDozent( rsmd, rs, xmlDoc);

        } catch (SQLException e) {
            System.out.println("SQLException: " + e.getMessage() );
        }           
        
        
    }
    
    static protected void transformDOMTreeToHTML( Document xmlDoc, PrintWriter responseOutput, String xslFile ) {
        OutputFormat format = new OutputFormat(xmlDoc);      // Serialize DOM
        StringWriter stringOut = new StringWriter();         // Writer will be a String            
        XMLSerializer serial = new XMLSerializer(stringOut, format);              
              
        try {
            serial.asDOMSerializer();                        // As a DOM Serializer
            serial.serialize(xmlDoc);

            // XML-Baum mit XSL-File transformieren
            if ( xslFile != "") {
                StringReader stringReader = new StringReader(stringOut.toString());
            
                Source xmlSource = new StreamSource(stringReader);
                String XSLUrl = "http://" + webservername + ":" + webserverport + "/" + webservercontext + "/stylesheets/" + xslFile;
                Source xslSource = new StreamSource(new URL(XSLUrl).openStream());
                
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(xslSource);
                transformer.transform(xmlSource, new StreamResult(responseOutput));
            }
            // XML-Baum ohne XSL-Transformation ausgeben
            else {
                responseOutput.println(stringOut.toString());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
   }
       
}
