package klocke.ws0203.mci2.online.xmluserinterface;

/*
 * Kurse.java
 * Written by: Heiner Klocke
 *
 * Created on 21. November 2002, 14:35
 * Modified on 21. November 2002

 */


// JAXP packages
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.w3c.dom.*;

// (xerces.jar)
import  org.w3c.dom.*;
import  org.apache.xerces.dom.DocumentImpl;
import  org.apache.xerces.dom.DOMImplementationImpl;
import  org.w3c.dom.Document;
import  org.apache.xml.serialize.OutputFormat;
import  org.apache.xml.serialize.Serializer;
import  org.apache.xml.serialize.SerializerFactory;
import  org.apache.xml.serialize.XMLSerializer;

// (xalan.jar)
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;

import java.net.URL;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

import klocke.ws0203.mci2.online.constants.ServletConstants;

public class Kurse implements ServletConstants {
//    private static final String DB = "klocke.ws0203.mci2.online.bundles.db";
    private static Connection verbindung;    
    private Statement stmt;
     
    private static String webservername = WEBSERVERNAME,
                   webserverport = WEBSERVERPORT,
                   webservercontext = WEBSERVERCONTEXT;

    private Element kurse, header, webserver, ueberschrift;
    
    
    /** Creates new Kurse */
    public Kurse() {
    }

    public Kurse( Connection verb ) {
        verbindung = verb;
    }
 
    public void selectRows ( HttpServletRequest request, PrintWriter responseOutput, DocumentBuilder dbl ) {

        Document xmlDoc = new DocumentImpl();
        
        try {
            stmt = verbindung.createStatement();
            StringBuffer colBuf = new StringBuffer();
 
            String query;
            query = "SELECT * FROM KURSE";
                

            ResultSet rs = stmt.executeQuery(query);            
            ResultSetMetaData rsmd = rs.getMetaData();

            buildDOMTree( rs, rsmd, xmlDoc);

            transformDOMTreeToHTML( xmlDoc, responseOutput, "showTable.xsl" );
//            transformDOMTreeToHTML( xmlDoc, responseOutput, "" );
            rs.close();
            stmt.close();
            }
        catch (SQLException e) {
            System.out.println("SQLException: " + e.getMessage() );
        }

       
    }

    
    public void buildDOMNodesKurs( ResultSetMetaData rsmd, ResultSet rs, Document xmlDoc ) throws SQLException {
        boolean moreRecords = rs.next();
        
        Element kurs, item;
  
        if (! moreRecords ) {
            kurs = xmlDoc.createElement("notupel");
            kurse.appendChild(kurs);
        }
    
        try {
            
            // get row data
            do {
                kurs = xmlDoc.createElement("tupel");
                kurse.appendChild(kurs);
                for ( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
                    item = xmlDoc.createElement(rsmd.getColumnName(i));
                    item.appendChild(xmlDoc.createTextNode( rs.getString(rsmd.getColumnName(i)) ));
                    kurs.appendChild(item);
                }
            } while (rs.next() );
          
        } catch ( SQLException sqlex ) {
            sqlex.printStackTrace();
        }
    }



    private void buildDOMTree( ResultSet rs, ResultSetMetaData rsmd, Document xmlDoc) {
        kurse = xmlDoc.createElement("showkurse");
        xmlDoc.appendChild(kurse);  
        header = xmlDoc.createElement("header");
        kurse.appendChild(header); 
        webserver = xmlDoc.createElement("webserver");
        kurse.appendChild(webserver);
        ueberschrift = xmlDoc.createElement("ueberschrift");
        kurse.appendChild(ueberschrift);
                     
        Element item;

        item = xmlDoc.createElement("webservername");
        item.appendChild(xmlDoc.createTextNode(webservername));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webserverport");
        item.appendChild(xmlDoc.createTextNode(webserverport));
        webserver.appendChild(item);
           
        item = xmlDoc.createElement("webservercontext");
        item.appendChild(xmlDoc.createTextNode(webservercontext));
        webserver.appendChild(item);           


        // DB-Spaltennamen in den DMO-Tree einfuegen
        try {
            
            for ( int i = 1; i <= rsmd.getColumnCount(); i++ ) {
                item = xmlDoc.createElement("c" + rsmd.getColumnName(i));
                item.appendChild(xmlDoc.createTextNode(rsmd.getColumnName(i)));
                ueberschrift.appendChild(item);
            }        
        } catch ( SQLException sqlex ) {
            sqlex.printStackTrace();
        }
            
        
        try {
        
            // all rows
            buildDOMNodesKurs( rsmd, rs, xmlDoc);

        } catch (SQLException e) {
            System.out.println("SQLException: " + e.getMessage() );
        }
    }
 
    static protected void transformDOMTreeToHTML( Document xmlDoc, PrintWriter responseOutput, String xslFile ) {
        OutputFormat format = new OutputFormat(xmlDoc);      // Serialize DOM
        StringWriter stringOut = new StringWriter();         // Writer will be a String            
        XMLSerializer serial = new XMLSerializer(stringOut, format);              
              
        try {
            serial.asDOMSerializer();                        // As a DOM Serializer
            serial.serialize(xmlDoc);

            // XML-Baum mit XSL-File transformieren
            if ( xslFile != "") {
                StringReader stringReader = new StringReader(stringOut.toString());
            
                Source xmlSource = new StreamSource(stringReader);
                String XSLUrl = "http://" + webservername + ":" + webserverport + "/" + webservercontext + "/stylesheets/" + xslFile;
                Source xslSource = new StreamSource(new URL(XSLUrl).openStream());
                
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(xslSource);
                transformer.transform(xmlSource, new StreamResult(responseOutput));
            }
            // XML-Baum ohne XSL-Transformation ausgeben
            else {
                responseOutput.println(stringOut.toString());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
   }
       
}
