package klocke.ws0203.mci2.online.xmluserinterface;

/*
 * Dozent.java
 * Written by: Heiner Klocke
 *
 * Created on 22. November 2002, 14:35
 * Modified on 22. November 2002
 *
 * Einfuegen eines DOZENTEN-Tupels

 */


// JAXP packages
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import org.w3c.dom.*;

// (xerces.jar) 
import  org.w3c.dom.*;
import  org.apache.xerces.dom.DocumentImpl;
import  org.apache.xerces.dom.DOMImplementationImpl;
import  org.w3c.dom.Document;
import  org.apache.xml.serialize.OutputFormat; 
import  org.apache.xml.serialize.Serializer;
import  org.apache.xml.serialize.SerializerFactory;
import  org.apache.xml.serialize.XMLSerializer;

// (xalan.jar)
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult; 

import java.net.URL;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import java.sql.*;
import java.util.*;

// Die HTML User Interface Klassen
import klocke.ws0203.mci2.online.constants.ServletConstants;
import klocke.ws0203.mci2.online.database.DBVerbindung; 

public class Studenten implements ServletConstants {
    
    private static Connection verbindung;    
    private Statement stmt;
   
    private static String webservername = WEBSERVERNAME,
                   webserverport = WEBSERVERPORT,
                   webservercontext = WEBSERVERCONTEXT;

    private Element Eanmeldung,
                    Elogin, 
                    Ematrnr,
                    Egebdat,
                    Ename,
                    Evorname,
                    Estudiengang,
                    Eselect,
                    Edpo,
                    Eemail;
    
    public String Modus;

    public String  studenten_id="", //
                   matrnr="",//
                   name="",
                   vorname="", 
                   studiengang="",
                   dpo="",
                   email="",
                   passwdmd5="",
                   zeitstempel="";    
    public int     gebdatDD= 1,//
                   gebdatMM= 1,//
                   gebdatYYYY= 1900;//
                   
   

    
//------------------------------------------------------------------------------    
    public Studenten() {
    }

    public Studenten(Connection verb) {
        verbindung = verb;
    }

//------------------------------------------------------------------------------    
    public void Identifizieren
        ( HttpServletRequest request, PrintWriter responseOutput,
          DocumentBuilder dbl){

        System.out.println("-->Student.Identifizieren modus: "+ Modus);
        Document xmlDoc = new DocumentImpl();

        
        Element  item;
        
        Eanmeldung = xmlDoc.createElement("anmeldung"); 
        Eanmeldung.setAttribute("modus", Modus);
        xmlDoc.appendChild(Eanmeldung);

        
        if ( Modus.equals("Login")){
           item = xmlDoc.createElement("titel");
                item.appendChild(xmlDoc.createTextNode("Identifikation"));
                Eanmeldung.appendChild(item);
            item = xmlDoc.createElement("ueberschrift");
                item.appendChild(xmlDoc.createTextNode("Bitte identifizieren Sie sich. Dazu wird ihre Matrikelnummer sowie ihr Geburtsdatum bentigt."));
                Eanmeldung.appendChild(item);
        }
        if ( Modus.equals("Registrieren / Login")){
           item = xmlDoc.createElement("titel");
                item.appendChild(xmlDoc.createTextNode("Identifikation - Registrieren / Login"));
                Eanmeldung.appendChild(item);
            item = xmlDoc.createElement("ueberschrift");
                item.appendChild(xmlDoc.createTextNode("Iher Daten wurden nicht gefunden. Entweder haben sie sich vertipt ODER Sie mussen sich erst Registrieren"));
                Eanmeldung.appendChild(item);
        }
        
        if ( Modus.equals("Registrieren")){
           item = xmlDoc.createElement("titel");
                item.appendChild(xmlDoc.createTextNode("Registrieren"));
                Eanmeldung.appendChild(item);
            item = xmlDoc.createElement("ueberschrift");
                item.appendChild(xmlDoc.createTextNode("Bitte fllen Sie die Felder um sich zu Registrieren"));
                Eanmeldung.appendChild(item);
        }
        
        
        
            Elogin = xmlDoc.createElement("login");
            Eanmeldung.appendChild(Elogin);

                Ematrnr = xmlDoc.createElement("matrnr"); 
                Elogin.appendChild(Ematrnr);
                item = xmlDoc.createElement("label");
                    item.appendChild(xmlDoc.createTextNode("Matrikel Nr."));
                    Ematrnr.appendChild(item);
                item = xmlDoc.createElement("feld");
                    item.setAttribute("name", "matrnr");
                    item.appendChild(xmlDoc.createTextNode(matrnr));
                    Ematrnr.appendChild(item);

                Egebdat = xmlDoc.createElement("gebdat"); 
                Elogin.appendChild(Egebdat);
            item = xmlDoc.createElement("label");
                    item.appendChild(xmlDoc.createTextNode("Geburtsdatum"));
                    Egebdat.appendChild(item);
                item = xmlDoc.createElement("dd");
                    item.setAttribute("size", "2");
                    item.appendChild(xmlDoc.createTextNode(""+gebdatDD));
                    Egebdat.appendChild(item);
                item = xmlDoc.createElement("mm");
                    item.setAttribute("size", "2");
                    item.appendChild(xmlDoc.createTextNode(""+gebdatMM));
                    Egebdat.appendChild(item);
                item = xmlDoc.createElement("yyyy");
                    item.setAttribute("size", "4");
                    item.appendChild(xmlDoc.createTextNode(""+gebdatYYYY));
                    Egebdat.appendChild(item);

        System.out.println("-->Student.Identifizieren transformDOMTreeToHTML: Identifizieren.xsl");
        transformDOMTreeToHTML( xmlDoc, responseOutput, "Identifizieren.xsl" );
        transformDOMTreeToHTML( xmlDoc, responseOutput, "" );
  
    } //ENDE Anmeldung

    
//------------------------------------------------------------------------------    
    public void Registrieren
        ( HttpServletRequest request, PrintWriter responseOutput,
          DocumentBuilder dbl){

        System.out.println("-->Student.Registrieren modus: "+ Modus);
        Document xmlDoc = new DocumentImpl();
        Document xmlDoc2 = new DocumentImpl();

        
        Element  item;
        
        Eanmeldung = xmlDoc.createElement("anmeldung"); 
        Eanmeldung.setAttribute("modus", Modus);
        xmlDoc.appendChild(Eanmeldung);

        
            item = xmlDoc.createElement("titel");
                item.appendChild(xmlDoc.createTextNode("Registrieren"));
                Eanmeldung.appendChild(item);
            item = xmlDoc.createElement("ueberschrift");
                item.appendChild(xmlDoc.createTextNode("Bitte geben Sie die gefordertrn Daten ein."));
                Eanmeldung.appendChild(item);
        
            Elogin = xmlDoc.createElement("login");
            Eanmeldung.appendChild(Elogin);

                Ematrnr = xmlDoc.createElement("matrnr"); 
                Elogin.appendChild(Ematrnr);
                item = xmlDoc.createElement("label");
                    item.appendChild(xmlDoc.createTextNode("Matrikel Nr."));
                    Ematrnr.appendChild(item);
                item = xmlDoc.createElement("feld");
                    item.setAttribute("name", "matrnr");
                    item.setAttribute("size", "8");
                    item.setAttribute("type", "TEXT");
                    item.appendChild(xmlDoc.createTextNode(matrnr));
                    Ematrnr.appendChild(item);

                Egebdat = xmlDoc.createElement("gebdat"); 
                Elogin.appendChild(Egebdat);
                item = xmlDoc.createElement("label");
                    item.appendChild(xmlDoc.createTextNode("Geburtsdatum"));
                    Egebdat.appendChild(item);
                item = xmlDoc.createElement("dd");
                    item.setAttribute("size", "2");
                    item.appendChild(xmlDoc.createTextNode(""+gebdatDD));
                    Egebdat.appendChild(item);
                item = xmlDoc.createElement("mm");
                    item.setAttribute("size", "2");
                    item.appendChild(xmlDoc.createTextNode(""+gebdatMM));
                    Egebdat.appendChild(item);
                item = xmlDoc.createElement("yyyy");
                    item.setAttribute("size", "4");
                    item.appendChild(xmlDoc.createTextNode(""+gebdatYYYY));
                    Egebdat.appendChild(item);

                Ename = xmlDoc.createElement("name"); 
                Elogin.appendChild(Ename);
                item = xmlDoc.createElement("label");
                    item.appendChild(xmlDoc.createTextNode("Nachname"));
                    Ename.appendChild(item);
                item = xmlDoc.createElement("feld");
                    item.setAttribute("name", "name");
                    item.setAttribute("size", "40");
                    item.setAttribute("type", "TEXT");
                    item.appendChild(xmlDoc.createTextNode(name));
                    Ename.appendChild(item);

                Evorname = xmlDoc.createElement("vorname"); 
                Elogin.appendChild(Evorname);
                item = xmlDoc.createElement("label");
                    item.appendChild(xmlDoc.createTextNode("Vorname"));
                    Evorname.appendChild(item);
                item = xmlDoc.createElement("feld");
                    item.setAttribute("name", "vorname");
                    item.setAttribute("size", "40");
                    item.setAttribute("type", "TEXT");
                    item.appendChild(xmlDoc.createTextNode(vorname));
                    Evorname.appendChild(item);

                Estudiengang = xmlDoc.createElement("studiengang"); 
                Elogin.appendChild(Estudiengang);
                item = xmlDoc.createElement("label");
                    item.appendChild(xmlDoc.createTextNode("Studiengang"));
                    Estudiengang.appendChild(item);
                    Eselect = xmlDoc.createElement("select");
                        Eselect.setAttribute("name", "studiengang");
                        Estudiengang.appendChild(Eselect);
                        item = xmlDoc.createElement("data");
                            item.appendChild(xmlDoc.createTextNode("AI"));
                            Eselect.appendChild(item);
                        item = xmlDoc.createElement("data");
                            item.appendChild(xmlDoc.createTextNode("TI"));
                            Eselect.appendChild(item);
                        item = xmlDoc.createElement("data");
                            item.appendChild(xmlDoc.createTextNode("MI"));
                            Eselect.appendChild(item);
                        item = xmlDoc.createElement("data");
                            item.appendChild(xmlDoc.createTextNode("WI"));
                            Eselect.appendChild(item);                            
                  
                Edpo = xmlDoc.createElement("dpo"); 
                Elogin.appendChild(Edpo);
                item = xmlDoc.createElement("label");
                    item.appendChild(xmlDoc.createTextNode("DPO"));
                    Edpo.appendChild(item);
                    Eselect = xmlDoc.createElement("select");
                        Eselect.setAttribute("name", "dpo");
                        Edpo.appendChild(Eselect);
                        item = xmlDoc.createElement("data");
                            item.appendChild(xmlDoc.createTextNode("2"));
                            Eselect.appendChild(item);
                        item = xmlDoc.createElement("data");
                            item.appendChild(xmlDoc.createTextNode("3"));
                            Eselect.appendChild(item);

                Eemail = xmlDoc.createElement("email"); 
                Elogin.appendChild(Eemail);
                item = xmlDoc.createElement("label");
                    item.appendChild(xmlDoc.createTextNode("E-Mail"));
                    Eemail.appendChild(item);
                item = xmlDoc.createElement("feld");
                    item.setAttribute("name", "email");
                    item.setAttribute("size", "40");
                    item.setAttribute("type", "TEXT");
                    item.appendChild(xmlDoc.createTextNode(email));
                    Eemail.appendChild(item);
                    
        System.out.println("-->Student.Registrieren transformDOMTreeToHTML: Registrieren.xsl");
        transformDOMTreeToHTML( xmlDoc, responseOutput, "Registrieren.xsl" );
        transformDOMTreeToHTML( xmlDoc, responseOutput, "" );
  
    } //ENDE Registrieren
    
    
    //------------------------------------------------------------------------------
    static protected void transformDOMTreeToHTML
        ( Document xmlDoc, PrintWriter responseOutput, String xslFile ) {
        
        OutputFormat format = new OutputFormat(xmlDoc);      // Serialize DOM
        StringWriter stringOut = new StringWriter();         // Writer will be a String            
        XMLSerializer serial = new XMLSerializer(stringOut, format);              
              
        try {
            serial.asDOMSerializer();                        // As a DOM Serializer
            serial.serialize(xmlDoc);

            // XML-Baum mit XSL-File transformieren
            if ( xslFile != "") {
                StringReader stringReader = new StringReader(stringOut.toString());
            
                Source xmlSource = new StreamSource(stringReader);
                String XSLUrl = "http://" + webservername + ":" + webserverport + "/" + webservercontext + "/stylesheets/" + xslFile;
                Source xslSource = new StreamSource(new URL(XSLUrl).openStream());
                
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer(xslSource);
                transformer.transform(xmlSource, new StreamResult(responseOutput));
            }
            // XML-Baum ohne XSL-Transformation ausgeben
            else {
                System.out.println(stringOut.toString());

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
   } // END transformDOMTreeToHTML

//------------------------------------------------------------------------------
   // return: 
    public boolean SqlIdentifikationTeste(){

        try {
            boolean RC;
            Statement stmt;
            stmt = verbindung.createStatement();
            StringBuffer colBuf = new StringBuffer();
            String query;

            query= "SELECT * FROM STUDENTEN WHERE "+
                "MATRNR = '"+ matrnr+ "' AND GEBDAT = '"+
                gebdatDD+ "-" + gebdatMM+ "-"+ gebdatYYYY+"' " ;
            System.out.println("-->Student.SqlIdentifikationTeste Query: " + query);

            ResultSet rs = stmt.executeQuery(query);            
            ResultSetMetaData rsmd = rs.getMetaData();

            RC = rs.next();
            if(RC == true){
                // Student ist identifiziert
                System.out.println("-->Student.SqlIdentifikationTeste Result: "+ rs.getString("NAME")+ " "+ rs.getString("VORNAME")  );
            }
            else{
                // Student muss sich registrieren oder daten sind falsch eingegeben
                System.out.println("-->Student.SqlIdentifikationTeste Result: no result.");
            }
            rs.close();
            stmt.close();
            return RC;
        }
        catch (SQLException e) {
            System.out.println("--> Student.SqlIdentifikationTeste SQLException: " + e.getMessage() );
            return false;
        }
    }// ENDE SqlIdentifikationTeste
    
//------------------------------------------------------------------------------
   //  
    public void SqlRegistrieren(){
        try {
            stmt = verbindung.createStatement();

            StringBuffer columns = new StringBuffer();

            // Namen der Spalten der Tabelle mcistudents
            columns.append("Studenten_id, ");
            columns.append("matrnr, ");
            columns.append("name, ");
            columns.append("vorname, ");
            columns.append("gebdat");
            
           
            // Datum und Zeit der Registrierung in der DB eintragen
//            HttpSession session = request.getSession(true);
//            java.sql.Date accessTime = new java.sql.Date(session.getLastAccessedTime());
            
//            System.out.println(accessTime);
//            String sqlDate = accessTime.toString();

//            System.out.println(sqlDate);
            
            StringBuffer values = new StringBuffer();
            values.append("'" + 2 + "', ");
            values.append("'" + matrnr + "', ");
            values.append("'" + name + "', ");
            values.append("'" + vorname + "', ");
            values.append("'" + gebdatDD+ "-" + gebdatMM+ "-"+ gebdatYYYY + "'");

            String query = "INSERT INTO studenten (" + columns + ") VALUES (" + values + ")";
            
            System.out.println(query); 
            
            stmt.executeUpdate(query);
            // Das commit macht der jdbc-driver
            
            stmt.close();
        } 
        catch (SQLException e) { 
            System.out.println("SQLException: " + e.getMessage() );
        }
    }    


}// END class
