<?xml version="1.0"?>


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="anmeldung">
   <html>
    <head>
     <title>
       <xsl:value-of select="titel"/>
     </title>
<!--     	<link rel="STYLESHEET" type="text/css" href="http://localhost:8080/mci2_online/stylesheets/mci.css"/>
-->    </head>
    <body>
     <xsl:apply-templates/>
    </body>
   </html>
   
  </xsl:template>

  <xsl:template match="titel"></xsl:template>

  <xsl:template match="ueberschrift">
    <h2> <xsl:value-of select="../titel"/> </h2>
    <xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="login">
    <form method="get" action = "">
            <table>
               <tr><td colspan="2" align="right"></td></tr>
                
               <tr><td colspan="2"><BR/></td></tr>
               <xsl:apply-templates select="matrnr | gebdat"/>
               <tr><td colspan="2"><BR/></td></tr>
               <xsl:apply-templates select="name | vorname | email"/>
               <tr><td colspan="2"><BR/></td></tr>
               <xsl:apply-templates select="studiengang | dpo"/>
               <tr><td colspan="2"><BR/></td></tr>

                <tr>
                    <td colspan="2" align="right">
                        <HR/>
                        <input type="submit">
                        <xsl:attribute name="value">
                                <xsl:value-of select="../@modus"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                                <xsl:text>modus</xsl:text>
                        </xsl:attribute>
                        </input>    	  
                    </td>
                </tr>
            </table>
     </form>
   	
  </xsl:template>

  
  <xsl:template match="matrnr | name | vorname | email">
      <tr>
            <td><xsl:apply-templates select="label"/></td>
            <td><xsl:apply-templates select="feld"/></td>
      </tr>
  </xsl:template>

    <xsl:template match="studiengang | dpo">
      <tr>
            <td><xsl:apply-templates select="label"/></td>
            <td><xsl:apply-templates select="select"/></td>
      </tr>
  </xsl:template>

  <xsl:template match="label">
  	<xsl:value-of select="."/><xsl:text>:</xsl:text>
  </xsl:template>

    <xsl:template match="feld">
 	<input>
        <xsl:attribute name="value">
  		<xsl:value-of select="."/>
  	</xsl:attribute>
  	<xsl:attribute name="type">
  		<xsl:value-of select="@type"/>
  	</xsl:attribute>
  	<xsl:attribute name="name">
  		<xsl:value-of select="@name"/>
  	</xsl:attribute>
  	<xsl:attribute name="size">
  		<xsl:value-of select="@size"/>
  	</xsl:attribute>
  	<xsl:attribute name="maxlength">
  		<xsl:value-of select="@size"/>
  	</xsl:attribute>    	  
        </input>
  </xsl:template>  
 
  <xsl:template match="select">
    <select size="1">
        <xsl:attribute name="name">
  		<xsl:value-of select="@name"/>
  	</xsl:attribute>
        <xsl:apply-templates select="data"/>
    </select>
  </xsl:template>  
  
  <xsl:template match="data">
    <option><xsl:value-of select="."/></option>
  </xsl:template>  
   
   
  <xsl:template match="gebdat">
    <tr>
            <td>
                <xsl:apply-templates select="label"/>
            </td>
            <td>
                <xsl:apply-templates select="dd | mm | yyyy"/>
            </td>
    </tr>
  </xsl:template>

  <xsl:template match="dd">
        <input type="text" name="dd" maxlength="2">
  	<xsl:attribute name="value">
  		<xsl:value-of select="."/>
  	</xsl:attribute>
  	<xsl:attribute name="size">
  		<xsl:value-of select="@size"/>
  	</xsl:attribute>
  	<xsl:attribute name="maxlength">
  		<xsl:value-of select="@size"/>
  	</xsl:attribute>    	  
  	</input>
        <a style="font-size:x-small"> <xsl:text>Tag&#160;&#160;</xsl:text></a>

  </xsl:template> 
 
   <xsl:template match="mm">
        <input type="text" name="mm" maxlength="2">
  	<xsl:attribute name="value">
  		<xsl:value-of select="."/>
  	</xsl:attribute>
  	<xsl:attribute name="size">
  		<xsl:value-of select="@size"/>
  	</xsl:attribute>
  	<xsl:attribute name="maxlength">
  		<xsl:value-of select="@size"/>
  	</xsl:attribute>    	  
  	</input>
        <a style="font-size:x-small"> <xsl:text>Monat&#160;&#160;</xsl:text></a>
  </xsl:template> 
 
   <xsl:template match="yyyy">
        <input type="text" name="yyyy" maxlength="2">
  	<xsl:attribute name="value">
  		<xsl:value-of select="."/>
  	</xsl:attribute>
  	<xsl:attribute name="size">
  		<xsl:value-of select="@size"/>
  	</xsl:attribute>
  	<xsl:attribute name="maxlength">
  		<xsl:value-of select="@size"/>
  	</xsl:attribute>    	  
  	</input>
        <a style="font-size:x-small"> <xsl:text>Jahr</xsl:text></a>

  </xsl:template> 
  
</xsl:stylesheet>
