<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE page [
 <!ENTITY nbsp "&#160;">
 <!ENTITY auml "&#228;">
 <!ENTITY ouml "&#246;">
 <!ENTITY uuml "&#252;">
 <!ENTITY Auml "&#196;">
 <!ENTITY Ouml "&#214;">
 <!ENTITY Uuml "&#220;">
 <!ENTITY szlig "&#223;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink">

<xsl:template match="/">
<xsl:param name="webservername" select="//webserver/webservername"/>
<xsl:param name="webserverport" select="//webserver/webserverport"/>
<xsl:param name="webservercontext" select="//webserver/webservercontext"/>
<xsl:param name="MATRNR" select="//student/MATRNR"/>

    <html>
    <head>
    	<title>Mensch-Computer Interaktion, SS 2002</title>
	</head>
    <body bgcolor="#fffffd">
    <h2>Kurs <i>Mensch-Computer Interaktion</i> im SS 2002 - getStudent</h2>

  <form method="get">
		<xsl:attribute name = "action">
			<xsl:value-of select="concat('http://', $webservername, ':', $webserverport, '/', $webservercontext, '/servlet/Mci2002Get')"/>
		</xsl:attribute>
    <table cellspacing='8'>
    	<tr>
    		<td align="left" style="color:grey">Matr-Nr</td>
        	<td align="left">
        		<input type="text" name="matrnr" size="9" maxlength="9">
        		<xsl:attribute name = "value">
<!--					<xsl:value-of select="$MATRNR"/> -->
				</xsl:attribute>
				</input>
        	</td>
        	<td><input type="submit" name="findmatrnr" value="suchen"/></td>
        	<td><input type="submit" name="deletematrnr" value="loeschen"/></td>

        </tr>
        </table>
    
	<table border="1" cellspacing="2" cellpadding="4" width="100%">
		<tr>
			<xsl:call-template name="header"/>
		</tr>
	</table>
	
	<p>
    <input type="submit" name="updatematrnr" value="aendern"/>
    <xsl:text> ohne Nachfrage !! </xsl:text>
    </p>	
    
	<table>
        <tr>
    	    <td>
        	<a> 
        		<xsl:attribute name = "href">
					<xsl:value-of select="concat('http://', $webservername, ':', $webserverport, '/', $webservercontext, '/mci')"/>
				</xsl:attribute>
        		<xsl:text>zum Men&uuml;</xsl:text>
        	</a>            
        	</td>
        </tr>
    </table>
    
  </form>

    </body>
   </html>
</xsl:template>

<xsl:template match="webserver">
</xsl:template>

<xsl:template name="header">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="NAME | VORNAME | MATRNR | ACCEPT | ALGO | BEMERKUNG | MAIL | REGTIME | SEMESTER | USERID">
	<td>
		<xsl:value-of select="."/>
	</td>
</xsl:template>


<xsl:template match="STUDIENGANG">
<xsl:param name="STUDIENGANG" select="//header/STUDIENGANG"/>
<!-- hole Matrnr des aktuellen "student"-node -->
<xsl:param name="MATRNR" select="../MATRNR"/>

	<td>
		<xsl:choose>
			<!-- Erklaerung siehe siehe Template 'FEHLTERMINE' -->
			<xsl:when test=". = 'Stdg'">
				<xsl:value-of select="."/>
			</xsl:when>
			<!-- Node "student" -->			
			<xsl:otherwise>
				<input type="text" size="2" maxlength="2">
					<xsl:attribute name="value">
						<xsl:value-of select="."/>
					</xsl:attribute>
					<xsl:attribute name="name">
						<xsl:value-of 
						 select="concat($STUDIENGANG, $MATRNR)"/>
					</xsl:attribute>					
				</input>
			</xsl:otherwise>
		</xsl:choose>
	</td>
</xsl:template>

<xsl:template match="GRUPPE">
<xsl:param name="GRUPPE" select="//header/GRUPPE"/>
<!-- hole Matrnr des aktuellen "student"-node -->
<xsl:param name="MATRNR" select="../MATRNR"/>
	<td>
		<xsl:choose>
			<!-- Erklaerung siehe siehe Template 'FEHLTERMINE' -->
			<xsl:when test=". = 'Gruppe'">
				<xsl:value-of select="."/>
			</xsl:when>
			<!-- Node "student" -->			
			<xsl:otherwise>
				<input type="text" size="2" maxlength="2">
					<xsl:attribute name="value">
						<xsl:value-of select="."/>
					</xsl:attribute>
					<xsl:attribute name="name">
						<xsl:value-of 
						 select="concat($GRUPPE, $MATRNR)"/>
					</xsl:attribute>					
				</input>
			</xsl:otherwise>

		</xsl:choose>
	</td>
</xsl:template>

<xsl:template match="BEMERKUNG">
<xsl:param name="BEMERKUNG" select="//header/BEMERKUNG"/>
<!-- hole Matrnr des aktuellen "student"-node -->
<xsl:param name="MATRNR" select="../MATRNR"/>
	<td>
		<xsl:choose>
			<!-- Erklaerung siehe siehe Template 'FEHLTERMINE' -->
			<!-- Node "HEADER" -->
			<xsl:when test=". = 'Bemerkung'">
				<xsl:value-of select="."/>
			</xsl:when>
			<!-- Node "student" -->			
			<xsl:otherwise>
				<input type="text" size="30" maxlength="200">
					<xsl:attribute name="value">
						<xsl:value-of select="."/>
					</xsl:attribute>
					<xsl:attribute name="name">
						<xsl:value-of 
						 select="concat($BEMERKUNG, $MATRNR)"/>
					</xsl:attribute>					
				</input>
			</xsl:otherwise>
		</xsl:choose>
	</td>
</xsl:template>

<xsl:template match="FEHLTERMINE">
<xsl:param name="FEHLTERMINE" select="//header/FEHLTERMINE"/>
<!-- hole Matrnr des aktuellen "student"-node -->
<xsl:param name="MATRNR" select="../MATRNR"/>
	<td>
		<xsl:choose>
			<!-- testen ob der Tagname = 'FEHLTERINE' = 'Fehltermine' oder 'ANERKANNT' = 'anerkannt'
			     wenn ja, dann wird die Ueberschrift ausgegeben
			     wenn nein, dann der Inhalt, z.B. die Anzahl der Fehltermin in einem
			     Eingabefeld ausgegeben.
			     <header>
			     	<FEHLTERMINE>Fehltermine</FEHLTERMINE>
			     	<ANERKANNT>anerkannt</ANERKANNT>
			     </header>
			     <student>
			     	...
			     	<FEHLTERMINE>1</FEHLTERMINE>
			     	<ANERKANNT>j</ANERKANNT>
			     </student>
			 -->
			<xsl:when test=". = 'Fehltermine'">
				<xsl:value-of select="."/>
			</xsl:when>
			<xsl:otherwise>
				<input type="text" size="2" maxlength="2">
				<xsl:attribute name="value">
					<xsl:value-of select="."/>
				</xsl:attribute>
				<xsl:attribute name="name">
						<xsl:value-of 
						 select="concat($FEHLTERMINE, $MATRNR)"/>
				</xsl:attribute>				
				</input>
			</xsl:otherwise>
		</xsl:choose>
	</td>
</xsl:template>

<xsl:template match="ANERKANNT">
<xsl:param name="ANERKANNT" select="//header/ANERKANNT"/>
<!-- hole Matrnr des aktuellen "student"-node -->
<xsl:param name="MATRNR" select="../MATRNR"/>

	<td>
		<xsl:choose>
			<!-- Erklaerung siehe Template 'FEHLTERMINE' -->
			<xsl:when test=". = 'anerkannt'">
				<xsl:value-of select="."/>
			</xsl:when>
			<xsl:otherwise>
				<input type="text" size="4" maxlength="4">
				<xsl:attribute name="value">
					<xsl:value-of select="."/>
				</xsl:attribute>
				<xsl:attribute name="name">
						<xsl:value-of 
						 select="concat($ANERKANNT, $MATRNR)"/>
				</xsl:attribute>				
				</input>
			</xsl:otherwise>
		</xsl:choose>
	</td>
	<td>
		<xsl:choose>	
			<xsl:when test="$MATRNR != 'Matr-Nr'">
				<input type="Checkbox" name="update" value="">
					<xsl:attribute name="value">
						<xsl:value-of select="$MATRNR"/>
					</xsl:attribute>
				</input>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>&nbsp;</xsl:text>
				
			</xsl:otherwise>							
		</xsl:choose>
	</td>
	
</xsl:template>


<xsl:template match="student">
	<tr>
		<xsl:apply-templates/>
	</tr>
</xsl:template>

<xsl:template match="nostudent">
	<xsl:text>Matrikelnummer </xsl:text>
	<b><xsl:value-of select = "."/></b>
	<xsl:text> nicht gefunden</xsl:text>
</xsl:template>

<xsl:template match="nogroup">
	<xsl:text>Gruppe </xsl:text>
	<b><xsl:value-of select = "."/></b>
	<xsl:text> nicht gefunden</xsl:text>
</xsl:template>


<xsl:template match="vorname">
	<tr>
		<td><xsl:text>Vorname: </xsl:text></td>
		<td><xsl:value-of select = "."/></td>
	</tr>
</xsl:template>

<xsl:template match="name">
	<tr>
		<td><xsl:text>Name: </xsl:text></td>
		<td><xsl:value-of select = "."/></td>
	</tr>		
</xsl:template>


<xsl:template match="matrikelnummer">
	<tr>
		<td><xsl:text>Matr-Nr: </xsl:text></td>
		<td><xsl:value-of select = "."/></td>
	</tr>		
</xsl:template>

<xsl:template match="mail">
	<tr>
		<td><xsl:text>URL: </xsl:text></td>
		<td><xsl:value-of select = "."/></td>
	</tr>
</xsl:template>

<xsl:template match="userid">
	<tr>
		<td><xsl:text>User-Id: </xsl:text></td>
		<td><xsl:value-of select = "."/></td>
	</tr>
</xsl:template>

</xsl:stylesheet>
