<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE page [
 <!ENTITY nbsp "&#160;">
 <!ENTITY auml "&#228;">
 <!ENTITY ouml "&#246;">
 <!ENTITY uuml "&#252;">
 <!ENTITY Auml "&#196;">
 <!ENTITY Ouml "&#214;">
 <!ENTITY Uuml "&#220;">
 <!ENTITY szlig "&#223;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink">

<xsl:template match="/">
	<xsl:param name="webservername" select="//webserver/webservername"/>
	<xsl:param name="webserverport" select="//webserver/webserverport"/>
	<xsl:param name="webservercontext" select="//webserver/webservercontext"/>
	
    <html>
    <head>
    	<title>MCI 2 - WS 02/03</title>
	</head>
    <body bgcolor="#fffffd">
    <h2>Neuen Dozenten anlegen</h2>

<!--	<form method="get" lang="de" accept-charset="ISO-8859-1, ISO-8859-2" action = "http://localhost:8080/mci2_online/servlet/klocke.ws0203.mci2.online.servlets.Mci2DozentenServlet"> -->
	<form method ="get" lang="de" accept-charset="ISO-8859-1, ISO-8859-2">
		<xsl:attribute name = "action">
			<xsl:value-of select="concat('http://', $webservername, ':', $webserverport, '/', $webservercontext, '/', 'servlet/klocke.ws0203.mci2.online.servlets.Mci2DozentenServlet')"/>
		</xsl:attribute>

	
   	<table bordercolor="White" cellspacing="4px" cellpadding="4px" bgcolor="White">
		<xsl:apply-templates/>
	</table>
	<input type="submit" name="dozenten" value="Eingabe sichern"/>
	<input type="reset" name="zuruecksetzen" value="Felder leeren"/>
	</form>	
	<br/>

	<a>
		<xsl:attribute name = "href">
			<xsl:value-of select="concat('http://', $webservername, ':', $webserverport, '/', $webservercontext, '/', 'servlet/klocke.ws0203.mci2.online.servlets.Mci2DozentenServlet?dozenten=functions')"/>
		</xsl:attribute>
		<xsl:text>Funktionen</xsl:text>
    </a>             	
	
    </body>
   </html>
</xsl:template>

<xsl:template match="dozenten_id">
<tr>
  <td align="right" width="100">Dozenten-Id</td>
  <td><input type="text" name="dozenten_id" size="8" maxlength="8"/></td>
</tr>
</xsl:template>

<xsl:template match="name">
<tr>
	<td align="right" style="color:grey">Name</td>
	<td><input type="text" name="name" size="30" maxlength="30"/></td>
</tr>
</xsl:template>


<xsl:template match="vorname">
<tr>
	<td align="right" style="color:grey">Vorname</td>
	<td><input type="text" name="vorname" size="30" maxlength="30"/></td>
</tr>
</xsl:template>

<xsl:template match="kuerzel">
<tr>
	<td align="right" style="color:grey">Kuerzel</td>
	<td><input type="text" name="kuerzel" id="kuerzel" size="30" maxlength="30"/> </td>
</tr>
</xsl:template>

<xsl:template match="url">
<tr>
	<td align="right" style="color:grey">URL</td>
	<td><input type="text" name="url" id="url" size="30" maxlength="100"/></td>
</tr>
</xsl:template>

<xsl:template match="email">
<tr>
	<td align="right">E-Mail</td>
	<td><input type="text" name="email" id="email" size="30" maxlength="100"/></td>
</tr>
</xsl:template>

<xsl:template match="passwdmd5">
<tr>
	<td align="right">Passwort</td>
	<td><input type="text" name="passwdmd5" id="passwdmd5" size="30" maxlength="100"/></td>
</tr>
</xsl:template>

<xsl:template match="webserver">
</xsl:template>

</xsl:stylesheet>
