<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE page [
 <!ENTITY nbsp "&#160;">
 <!ENTITY auml "&#228;">
 <!ENTITY ouml "&#246;">
 <!ENTITY uuml "&#252;">
 <!ENTITY Auml "&#196;">
 <!ENTITY Ouml "&#214;">
 <!ENTITY Uuml "&#220;">
 <!ENTITY szlig "&#223;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink">

<xsl:template match="/">
	<xsl:param name="webservername" select="//webserver/webservername"/>
	<xsl:param name="webserverport" select="//webserver/webserverport"/>
	<xsl:param name="webservercontext" select="//webserver/webservercontext"/>

    <html>
    <head>
    	<title>MCI 2 - WS 02/03</title>
	</head>
    <body bgcolor="#fffffd">
    <h2>Dozenten</h2>



<!--	<form method="get" action = "http://localhost:8080/mci2_online/servlet/klocke.ws0203.mci2.online.servlets.Mci2DozentenServlet">   -->

	<form method ="get">
		<xsl:attribute name = "action">
			<xsl:value-of select="concat('http://', $webservername, ':', $webserverport, '/', $webservercontext, '/', 'servlet/klocke.ws0203.mci2.online.servlets.Mci2DozentenServlet')"/>
		</xsl:attribute>
	
   	<table bordercolor="White" cellspacing="4px" cellpadding="4px" bgcolor="White">
   		<tr bgcolor="#FFB366">
			<xsl:apply-templates/>
   		</tr>
   		
   		<tr>
			<xsl:call-template name="tail"/>    		
   			<td colspan="7">&nbsp;</td>
   			<td>
   				<input type="submit" name="dozenten" value="loeschen"/>
   			</td>
   		</tr>
	</table>
	
	</form>
	
    </body>
   </html>
</xsl:template>

<xsl:template match="tupel">
	<tr>
		<xsl:apply-templates/>
	</tr>
</xsl:template>

<xsl:template match="cDOZENTEN_ID">
	<th>
		<xsl:text>Dozenten-Id</xsl:text>		
	</th>
</xsl:template>

<!-- c steht fuer column und bedeutet, dass nach dem c ein DBSpaltenname kommt. Passende Ueberschrift ausgeben -->
<xsl:template match="cVORNAME">
	<th>
		<xsl:text>Vorname</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cNAME">
	<th>
		<xsl:text>Name</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cKUERZEL">
	<th>
		<xsl:text>Kuerzel</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cURL">
	<th>
		<xsl:text>URL</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cEMAIL">
	<th>
		<xsl:text>E-Mail</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cPASSWDMD5">
	<th>
		<xsl:text>Password</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cDOZENTEN_ZEITSTEMPEL">
	<th>
		<xsl:text>Zeitstempel</xsl:text>		
	</th>
</xsl:template>

<!-- Spalten der Tabelle DOZENTEN -->
<xsl:template match="DOZENTEN_ID | VORNAME | NAME | KUERZEL | URL | EMAIL | PASSWDMD5 | DOZENTEN_ZEITSTEMPEL ">
	<td>
		<xsl:value-of select="."/>
	</td>
</xsl:template>


<xsl:template match="delTup">
	<td>
		<input type="checkbox" name="dozenten_id">
			<xsl:attribute name="value">
				<xsl:value-of select="."/>
			</xsl:attribute>
		</input>
	</td>
</xsl:template>

<xsl:template match="notupel">
	<h3>
		<xsl:text>Es wurden keine Daten gefunden</xsl:text>
	</h3>
</xsl:template>

<xsl:template match="webserver">
</xsl:template>

<xsl:template name="tail">
	<xsl:param name="webservername" select="//webserver/webservername"/>
	<xsl:param name="webserverport" select="//webserver/webserverport"/>
	<xsl:param name="webservercontext" select="//webserver/webservercontext"/>
	<td>
	<a>
		<xsl:attribute name = "href">
			<xsl:value-of select="concat('http://', $webservername, ':', $webserverport, '/', $webservercontext, '/', 'servlet/klocke.ws0203.mci2.online.servlets.Mci2DozentenServlet?dozenten=functions')"/>
		</xsl:attribute>
    	<xsl:text>zur&uuml;ck</xsl:text>
    </a>
    </td>            
</xsl:template>

</xsl:stylesheet>
