<?xml version="1.0" encoding="UTF-8"?>

<!DOCTYPE page [
 <!ENTITY nbsp "&#160;">
 <!ENTITY auml "&#228;">
 <!ENTITY ouml "&#246;">
 <!ENTITY uuml "&#252;">
 <!ENTITY Auml "&#196;">
 <!ENTITY Ouml "&#214;">
 <!ENTITY Uuml "&#220;">
 <!ENTITY szlig "&#223;">
]>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink">

<xsl:template match="/">
    <html>
    <head>
    	<title>MCI 2 - WS 02/03</title>
	</head>
    <body bgcolor="#fffffd">
    <h2>Praktikum <i>Mensch-Computer Interaktion</i> im WS 2002/2003 - Tabelle</h2>

   
   	<table bordercolor="White" cellspacing="4px" cellpadding="4px" bgcolor="White">
   		<tr bgcolor="#FFB366">
			<xsl:apply-templates/>
   		</tr>
	</table>
	
	<xsl:call-template name="tail"/>
	
    </body>
   </html>
</xsl:template>

<xsl:template match="tupel">
	<tr>
		<xsl:apply-templates/>
	</tr>
</xsl:template>

<xsl:template match="cDOZENTEN_ID">
	<th>
		<xsl:text>Dozenten-Id</xsl:text>		
	</th>
</xsl:template>

<!-- c steht fuer column und bedeutet, dass nach dem c ein DBSpaltenname kommt. Passende Ueberschrift ausgeben -->
<xsl:template match="cVORNAME">
	<th>
		<xsl:text>Vorname</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cNAME">
	<th>
		<xsl:text>Name</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cKUERZEL">
	<th>
		<xsl:text>Kuerzel</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cURL">
	<th>
		<xsl:text>URL</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cEMAIL">
	<th>
		<xsl:text>E-Mail</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cPASSWDMD5">
	<th>
		<xsl:text>Password</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cKURSE_ID">
	<th>
		<xsl:text>Kurs-Id</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cKURSNAME">
	<th>
		<xsl:text>Kursname</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cKURSTYP">
	<th>
		<xsl:text>Kurstyp</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cKURSKUERZEL">
	<th>
		<xsl:text>Kursk&uuml;rzel</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cZEITRAUM">
	<th>
		<xsl:text>Zeitraum</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cTERMINZYKLUS">
	<th>
		<xsl:text>Terminzyklus</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cSTUDIENGANG">
	<th>
		<xsl:text>Studiengang</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cANZSEMESTER">
	<th>
		<xsl:text>Semesteranzahl</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cANZSTUDENTEN">
	<th>
		<xsl:text>Anzahlstudenten</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cANKUENDIGUNG">
	<th>
		<xsl:text>Ankuendigung</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cANMELDENBIS">
	<th>
		<xsl:text>anmelden bis</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cVORKENNTNISSE">
	<th>
		<xsl:text>Vorkenntnisse</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cFREIGABE">
	<th>
		<xsl:text>Freigabe</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cZEITSTEMPEL">
	<th>
		<xsl:text>Zeitstempel</xsl:text>		
	</th>
</xsl:template>

<xsl:template match="cDOZENTEN_ZEITSTEMPEL">
	<th>
		<xsl:text>Zeitstempel</xsl:text>		
	</th>
</xsl:template>

<!-- Spalten der Tabelle DOZENTEN -->
<xsl:template match="DOZENTEN_ID | NAME | KUERZEL | URL | EMAIL | PASSWDMD5 | DOZENTEN_ZEITSTEMPEL ">
	<td>
		<xsl:value-of select="."/>
	</td>
</xsl:template>

<xsl:template match="VORNAME">
	<td style="color:red">
		<xsl:value-of select="."/>
	</td>
</xsl:template>

<!-- Spalten der Tabelle KURSE -->
<xsl:template match="KURSE_ID | KURSNAME | KURSTYP | KURSKUERZEL | ZEITRAUM | TERMINZYKLUS | STUDIENGANG | ANZSEMESTER | ANZSTUDENTEN | ANKUENDIGUNG | ANMELDENBIS | VORKENNTNISSE | FREIGABE | DOZENTEN_ID | ZEITSTEMPEL ">
	<td>
		<xsl:value-of select="."/>
	</td>
</xsl:template>


<xsl:template match="webserver">
</xsl:template>

<xsl:template name="tail">
	<xsl:param name="webservername" select="//webserver/webservername"/>
	<xsl:param name="webserverport" select="//webserver/webserverport"/>
	<xsl:param name="webservercontext" select="//webserver/webservercontext"/>
		
    <br/>
    <table>
    	<tr>
    		<td>
    			<a>
    				<xsl:attribute name = "href">
							<xsl:value-of select="concat('http://', $webservername, ':', $webserverport, '/', $webservercontext)"/>
					</xsl:attribute>
    				<xsl:text>zum Men&uuml;</xsl:text>
    			</a>            
            </td>
        </tr>
    </table>
</xsl:template>

</xsl:stylesheet>
